/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.stream.impl;

import java.util.function.Predicate;
import org.teavm.classlib.java.util.stream.impl.TSimpleStreamImpl;

public class TLimitingStreamImpl<T>
extends TSimpleStreamImpl<T> {
    private TSimpleStreamImpl<T> sourceStream;
    private int limit;
    private int remaining;

    public TLimitingStreamImpl(TSimpleStreamImpl<T> sourceStream, int limit) {
        this.sourceStream = sourceStream;
        this.limit = limit;
        this.remaining = limit;
    }

    @Override
    public boolean next(Predicate<? super T> consumer) {
        if (this.remaining == 0) {
            return false;
        }
        boolean result = this.sourceStream.next(e -> {
            boolean hasRemaining = --this.remaining > 0;
            return consumer.test(e) && hasRemaining;
        });
        if (!result) {
            this.remaining = 0;
        }
        return this.remaining > 0;
    }

    @Override
    protected int estimateSize() {
        int sourceEstimation = this.sourceStream.estimateSize();
        return sourceEstimation < 0 ? this.limit : Math.min(this.limit, sourceEstimation);
    }

    @Override
    public void close() throws Exception {
        this.sourceStream.close();
    }
}

