/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.jar;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Map;
import org.teavm.classlib.java.util.jar.TAttributes;
import org.teavm.classlib.java.util.jar.TManifest;

class TInitManifest {
    private byte[] buf;
    private int pos;
    TAttributes.Name name;
    String value;
    CharsetDecoder decoder = Charset.defaultCharset().newDecoder();
    CharBuffer cBuf = CharBuffer.allocate(512);
    int linebreak;

    TInitManifest(byte[] buf, TAttributes main, TAttributes.Name ver) throws IOException {
        this.buf = buf;
        if (!this.readHeader() || ver != null && !this.name.equals(ver)) {
            throw new IOException();
        }
        main.put(this.name, this.value);
        while (this.readHeader()) {
            main.put(this.name, this.value);
        }
    }

    void initEntries(Map<String, TAttributes> entries, Map<String, TManifest.Chunk> chunks) throws IOException {
        int mark = this.pos;
        while (this.readHeader()) {
            if (!TAttributes.Name.NAME.equals(this.name)) {
                throw new IOException();
            }
            String entryNameValue = this.value;
            TAttributes entry = entries.get(entryNameValue);
            if (entry == null) {
                entry = new TAttributes(12);
            }
            while (this.readHeader()) {
                entry.put(this.name, this.value);
            }
            if (chunks != null) {
                if (chunks.get(entryNameValue) != null) {
                    throw new IOException();
                }
                chunks.put(entryNameValue, new TManifest.Chunk(mark, this.pos));
                mark = this.pos;
            }
            entries.put(entryNameValue, entry);
        }
    }

    int getPos() {
        return this.pos;
    }

    private boolean readHeader() throws IOException {
        if (this.linebreak > 1) {
            this.linebreak = 0;
            return false;
        }
        this.readName();
        this.linebreak = 0;
        this.readValue();
        return this.linebreak > 0;
    }

    private byte[] wrap(int mark, int pos) {
        byte[] buffer = new byte[pos - mark];
        System.arraycopy(this.buf, mark, buffer, 0, pos - mark);
        return buffer;
    }

    private void readName() throws IOException {
        int mark = this.pos;
        while (this.pos < this.buf.length) {
            byte b;
            if ((b = this.buf[this.pos++]) == 58) {
                byte[] nameBuffer = this.wrap(mark, this.pos - 1);
                if (this.buf[this.pos++] != 32) {
                    throw new IOException();
                }
                this.name = new TAttributes.Name(nameBuffer);
                return;
            }
            if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b == 95 || b == 45 || b >= 48 && b <= 57) continue;
            throw new IOException();
        }
    }

    private void readValue() throws IOException {
        boolean lastCr = false;
        int mark = this.pos;
        int last = this.pos;
        this.decoder.reset();
        this.cBuf.clear();
        block6: while (this.pos < this.buf.length) {
            byte next = this.buf[this.pos++];
            switch (next) {
                case 0: {
                    throw new IOException();
                }
                case 10: {
                    if (lastCr) {
                        lastCr = false;
                        continue block6;
                    }
                    ++this.linebreak;
                    continue block6;
                }
                case 13: {
                    lastCr = true;
                    ++this.linebreak;
                    continue block6;
                }
                case 32: {
                    if (this.linebreak != 1) break;
                    this.decode(mark, last, false);
                    last = mark = this.pos;
                    this.linebreak = 0;
                    continue block6;
                }
            }
            if (this.linebreak >= 1) {
                --this.pos;
                break;
            }
            last = this.pos;
        }
        this.decode(mark, last, true);
        while (CoderResult.OVERFLOW == this.decoder.flush(this.cBuf)) {
            this.enlargeBuffer();
        }
        this.value = new String(this.cBuf.array(), this.cBuf.arrayOffset(), this.cBuf.position());
    }

    private void decode(int mark, int pos, boolean endOfInput) throws IOException {
        ByteBuffer bBuf = ByteBuffer.wrap(this.buf, mark, pos - mark);
        while (CoderResult.OVERFLOW == this.decoder.decode(bBuf, this.cBuf, endOfInput)) {
            this.enlargeBuffer();
        }
    }

    private void enlargeBuffer() {
        CharBuffer newBuf = CharBuffer.allocate(this.cBuf.capacity() * 2);
        newBuf.put(this.cBuf.array(), this.cBuf.arrayOffset(), this.cBuf.position());
        this.cBuf = newBuf;
    }
}

