/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util.concurrent;

import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneNotSupportedException;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TIllegalArgumentException;
import org.teavm.classlib.java.lang.TIllegalStateException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.util.TAbstractCollection;
import org.teavm.classlib.java.util.TAbstractMap;
import org.teavm.classlib.java.util.TAbstractSet;
import org.teavm.classlib.java.util.TCollection;
import org.teavm.classlib.java.util.TConcurrentModificationException;
import org.teavm.classlib.java.util.TIterator;
import org.teavm.classlib.java.util.TMap;
import org.teavm.classlib.java.util.TNoSuchElementException;
import org.teavm.classlib.java.util.TSet;
import org.teavm.classlib.java.util.concurrent.TConcurrentMap;
import org.teavm.classlib.java.util.concurrent.TMapEntry;
import org.teavm.interop.Rename;

public class TConcurrentHashMap<K, V>
extends TAbstractMap<K, V>
implements TConcurrentMap<K, V>,
TCloneable,
TSerializable {
    private transient int elementCount;
    private transient HashEntry<K, V>[] elementData;
    private transient int modCount;
    private static final int DEFAULT_SIZE = 16;
    private final float loadFactor;
    private int threshold;
    private transient TSet<K> cachedKeySet;
    private transient TCollection<V> cachedValues;

    HashEntry<K, V>[] newElementArray(int s) {
        return new HashEntry[s];
    }

    public TConcurrentHashMap() {
        this(16);
    }

    public TConcurrentHashMap(int capacity) {
        this(capacity, 0.75f);
    }

    private static int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public TConcurrentHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new TIllegalArgumentException();
        }
        capacity = TConcurrentHashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = loadFactor;
        this.computeThreshold();
    }

    public TConcurrentHashMap(TMap<? extends K, ? extends V> map) {
        this(TConcurrentHashMap.calculateCapacity(map.size()));
        this.putAllImpl(map);
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    @Rename(value="clone")
    public TObject clone0() {
        try {
            TConcurrentHashMap map = (TConcurrentHashMap)super.clone();
            map.elementCount = 0;
            map.elementData = this.newElementArray(this.elementData.length);
            map.putAll(this);
            return map;
        }
        catch (TCloneNotSupportedException e) {
            return null;
        }
    }

    private void computeThreshold() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getEntry(key) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsValue(Object value) {
        int i;
        block0: while (true) {
            HashEntry<K, V>[] table = this.elementData;
            if (value == null) {
                i = 0;
                break;
            }
            i = 0;
            while (i < table.length) {
                HashEntry<K, V> first;
                while ((first = table[i]) != null) {
                    HashEntry<K, V> entry = first;
                    while (entry != null) {
                        boolean equal = TConcurrentHashMap.areEqualValues(value, entry.value);
                        if (table != this.elementData) continue block0;
                        if (equal) {
                            return true;
                        }
                        entry = entry.next;
                    }
                    if (first != table[i]) continue;
                }
                ++i;
            }
            return false;
        }
        while (i < this.elementData.length) {
            HashEntry<K, V> entry = this.elementData[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
            ++i;
        }
        return false;
    }

    @Override
    public TSet<TMap.Entry<K, V>> entrySet() {
        return new HashMapEntrySet(this);
    }

    @Override
    public V get(Object key) {
        HashEntry<K, V> m = this.getEntry(key);
        if (m != null) {
            return (V)m.value;
        }
        return null;
    }

    @Override
    public boolean remove(Object key, Object value) {
        HashEntry<K, V> entry = this.getEntryByKeyAndValue(key, value);
        if (entry != null) {
            this.removeEntry(entry);
            return true;
        }
        return false;
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        HashEntry<K, V> entry = this.getEntryByKeyAndValue(key, oldValue);
        if (entry != null) {
            entry.setValue(newValue);
            return true;
        }
        return false;
    }

    @Override
    public V replace(K key, V value) {
        HashEntry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        Object result = entry.getValue();
        entry.setValue(value);
        return result;
    }

    @Override
    public V getOrDefault(Object key, V defaultValue) {
        HashEntry<K, V> m = this.getEntry(key);
        return m != null ? m.getValue() : defaultValue;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        HashEntry<K, V>[] table;
        Objects.requireNonNull(action);
        for (HashEntry<K, V> entry : table = this.elementData) {
            while (entry != null) {
                if (!entry.removed) {
                    action.accept(entry.getKey(), entry.getValue());
                }
                entry = entry.next;
            }
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        int hash = Objects.hashCode(key);
        HashEntry<K, V> entry = this.getEntry(key, hash);
        if (entry != null) {
            return entry.getValue();
        }
        int index = this.computeIndex(hash);
        entry = this.placeHashedEntry(key, index, hash);
        entry.setValue(value);
        return null;
    }

    @Override
    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        HashEntry<K, V>[] table;
        Objects.requireNonNull(function);
        for (HashEntry<K, V> entry : table = this.elementData) {
            while (entry != null) {
                if (!entry.removed) {
                    V newValue = function.apply(entry.getKey(), entry.getValue());
                    Objects.requireNonNull(newValue);
                    entry.setValue(newValue);
                }
                entry = entry.next;
            }
        }
    }

    @Override
    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        int hash = Objects.hashCode(key);
        HashEntry<K, V> entry = this.getEntry(key, hash);
        if (entry != null) {
            return entry.getValue();
        }
        V newValue = mappingFunction.apply(key);
        entry = this.getEntry(key, hash);
        if (entry != null) {
            return entry.getValue();
        }
        int index = this.computeIndex(hash);
        entry = this.placeHashedEntry(key, index, hash);
        entry.setValue(newValue);
        return newValue;
    }

    @Override
    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Object oldValue;
        HashEntry<K, V> entry;
        int hash = Objects.hashCode(key);
        V newValue = null;
        boolean newValueComputed = false;
        do {
            if ((entry = this.getEntry(key, hash)) == null) {
                return null;
            }
            oldValue = entry.getValue();
            if (!newValueComputed) {
                newValueComputed = true;
                newValue = remappingFunction.apply(key, oldValue);
            }
            if ((entry = this.getEntry(key, hash)) != null) continue;
            return null;
        } while (entry.getValue() != oldValue);
        entry.setValue(newValue);
        return newValue;
    }

    @Override
    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        V newValue;
        HashEntry<K, V> entry;
        int hash = Objects.hashCode(key);
        while (true) {
            if ((entry = this.getEntry(key, hash)) == null) {
                V newValue2 = remappingFunction.apply(key, null);
                if (this.getEntry(key, hash) != null) continue;
                if (newValue2 != null) {
                    int index = this.computeIndex(hash);
                    entry = this.placeHashedEntry(key, index, hash);
                    entry.setValue(newValue2);
                }
                return newValue2;
            }
            Object oldValue = entry.getValue();
            newValue = remappingFunction.apply(key, oldValue);
            entry = this.getEntry(key, hash);
            if (entry != null && entry.getValue() == oldValue) break;
        }
        if (newValue == null) {
            this.removeEntry(entry);
        } else {
            entry.setValue(newValue);
        }
        return newValue;
    }

    private HashEntry<K, V> getEntry(Object key) {
        return this.getEntry(key, Objects.hashCode(key));
    }

    private HashEntry<K, V> getEntry(Object key, int hash) {
        if (key == null) {
            return this.findNullKeyEntry();
        }
        block0: while (true) {
            HashEntry<K, V>[] table = this.elementData;
            int index = hash & table.length - 1;
            block1: while (true) {
                HashEntry<K, V> first;
                if ((first = table[index]) == null) {
                    return null;
                }
                HashEntry<K, V> m = first;
                while (m != null) {
                    if (!m.removed && m.origKeyHash == hash) {
                        boolean equal = TConcurrentHashMap.areEqualKeys(key, m.key);
                        if (table != this.elementData) continue block0;
                        if (equal) {
                            if (m.removed) continue block1;
                            return m;
                        }
                    }
                    m = m.next;
                }
                if (first == table[index]) break block0;
            }
            break;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private HashEntry<K, V> getEntryByKeyAndValue(Object key, Object value) {
        hash = Objects.hashCode(key);
        block0: while (true) lbl-1000:
        // 3 sources

        {
            table = this.elementData;
            index = hash & table.length - 1;
            block1: while (true) {
                if ((first = table[index]) == null) {
                    return null;
                }
                m = first;
                while (m != null) {
                    block5: {
                        if (m.origKeyHash != hash) break block5;
                        v0 = key != null ? TConcurrentHashMap.areEqualKeys(key, m.key) : (equal = m.key == null);
                        if (table != this.elementData) ** GOTO lbl-1000
                        if (m.removed) continue block1;
                        if (equal) {
                            equal = TConcurrentHashMap.areEqualValues(value, m.value);
                            if (table != this.elementData) continue block0;
                            if (m.removed) continue block1;
                            return equal != false ? m : null;
                        }
                    }
                    m = m.next;
                }
                if (first == table[index]) break block0;
            }
            break;
        }
        return null;
    }

    private HashEntry<K, V> findNullKeyEntry() {
        HashEntry<K, V> m = this.elementData[0];
        while (m != null && m.key != null) {
            m = m.next;
        }
        return m;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public TSet<K> keySet() {
        if (this.cachedKeySet == null) {
            this.cachedKeySet = new TAbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return TConcurrentHashMap.this.containsKey(object);
                }

                @Override
                public int size() {
                    return TConcurrentHashMap.this.size();
                }

                @Override
                public void clear() {
                    TConcurrentHashMap.this.clear();
                }

                @Override
                public boolean remove(Object key) {
                    HashEntry entry = TConcurrentHashMap.this.getEntry(key);
                    if (entry != null) {
                        TConcurrentHashMap.this.removeEntry(entry);
                        return true;
                    }
                    return false;
                }

                @Override
                public TIterator<K> iterator() {
                    return new KeyIterator(TConcurrentHashMap.this);
                }
            };
        }
        return this.cachedKeySet;
    }

    @Override
    public V put(K key, V value) {
        return this.putImpl(key, value);
    }

    private V putImpl(K key, V value) {
        int hash = Objects.hashCode(key);
        HashEntry<K, V> entry = this.getEntry(key, hash);
        int index = this.computeIndex(hash);
        if (entry == null) {
            entry = this.placeHashedEntry(key, index, hash);
        }
        Object result = entry.value;
        entry.value = value;
        return (V)result;
    }

    private HashEntry<K, V> placeHashedEntry(K key, int index, int hash) {
        HashEntry<K, V> entry = this.createHashedEntry(key, index, hash);
        ++this.modCount;
        if (++this.elementCount > this.threshold) {
            this.rehash();
        }
        return entry;
    }

    private HashEntry<K, V> createHashedEntry(K key, int index, int hash) {
        HashEntry entry = new HashEntry(key, hash);
        entry.next = this.elementData[index];
        this.elementData[index] = entry;
        return entry;
    }

    @Override
    public void putAll(TMap<? extends K, ? extends V> map) {
        if (!map.isEmpty()) {
            this.putAllImpl(map);
        }
    }

    private void putAllImpl(TMap<? extends K, ? extends V> map) {
        int capacity = this.elementCount + map.size();
        if (capacity > this.threshold) {
            this.rehash(capacity);
        }
        TIterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            TMap.Entry entry = (TMap.Entry)iter.next();
            this.putImpl(entry.getKey(), entry.getValue());
        }
    }

    private void rehash(int capacity) {
        int length = TConcurrentHashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        HashEntry<K, V>[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            HashEntry<K, V> entry = this.elementData[i];
            this.elementData[i] = null;
            while (entry != null) {
                int index = entry.origKeyHash & length - 1;
                HashEntry next = entry.next;
                entry.next = newData[index];
                newData[index] = entry;
                entry = next;
            }
        }
        this.elementData = newData;
        this.computeThreshold();
    }

    private void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(Object key) {
        HashEntry<K, V> entry = this.getEntry(key);
        if (entry == null) {
            return null;
        }
        this.removeEntry(entry);
        return (V)entry.value;
    }

    private void removeEntry(HashEntry<K, V> entry) {
        int index = entry.origKeyHash & this.elementData.length - 1;
        HashEntry<K, V> m = this.elementData[index];
        if (m == entry) {
            this.elementData[index] = entry.next;
        } else {
            while (m.next != entry) {
                m = m.next;
            }
            m.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        entry.removed = true;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public TCollection<V> values() {
        if (this.cachedValues == null) {
            this.cachedValues = new TAbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return TConcurrentHashMap.this.containsValue(object);
                }

                @Override
                public int size() {
                    return TConcurrentHashMap.this.size();
                }

                @Override
                public void clear() {
                    TConcurrentHashMap.this.clear();
                }

                @Override
                public TIterator<V> iterator() {
                    return new ValueIterator(TConcurrentHashMap.this);
                }
            };
        }
        return this.cachedValues;
    }

    private static boolean areEqualKeys(Object key1, Object key2) {
        return key1 == key2 || key1.equals(key2);
    }

    private static boolean areEqualValues(Object value1, Object value2) {
        return value1 == value2 || value1.equals(value2);
    }

    private int computeIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.elementData.length;
    }

    static class HashEntry<K, V>
    extends TMapEntry<K, V> {
        final int origKeyHash;
        HashEntry<K, V> next;
        boolean removed;

        HashEntry(K theKey, int hash) {
            super(theKey, null);
            this.origKeyHash = hash;
        }

        @Override
        public Object clone() {
            HashEntry entry = (HashEntry)super.clone();
            if (this.next != null) {
                entry.next = (HashEntry)this.next.clone();
            }
            return entry;
        }
    }

    static class HashMapEntrySet<K, V>
    extends TAbstractSet<TMap.Entry<K, V>> {
        private final TConcurrentHashMap<K, V> associatedMap;

        HashMapEntrySet(TConcurrentHashMap<K, V> hm) {
            this.associatedMap = hm;
        }

        TConcurrentHashMap<K, V> hashMap() {
            return this.associatedMap;
        }

        @Override
        public int size() {
            return this.associatedMap.elementCount;
        }

        @Override
        public void clear() {
            this.associatedMap.clear();
        }

        @Override
        public boolean remove(Object object) {
            TMap.Entry oEntry;
            HashEntry<K, V> entry;
            if (object instanceof TMap.Entry && (entry = this.associatedMap.getEntryByKeyAndValue((oEntry = (TMap.Entry)object).getKey(), oEntry.getValue())) != null) {
                this.associatedMap.removeEntry(entry);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof TMap.Entry) {
                TMap.Entry oEntry = (TMap.Entry)object;
                return this.associatedMap.getEntryByKeyAndValue(oEntry.getKey(), oEntry.getValue()) != null;
            }
            return false;
        }

        @Override
        public TIterator<TMap.Entry<K, V>> iterator() {
            return new EntryIterator<K, V>(this.associatedMap);
        }
    }

    private static class ValueIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<V> {
        ValueIterator(TConcurrentHashMap<K, V> map) {
            super(map);
        }

        @Override
        public V next() {
            this.makeNext();
            return (V)this.currentEntry.value;
        }
    }

    private static class KeyIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<K> {
        KeyIterator(TConcurrentHashMap<K, V> map) {
            super(map);
        }

        @Override
        public K next() {
            this.makeNext();
            return (K)this.currentEntry.key;
        }
    }

    private static class EntryIterator<K, V>
    extends AbstractMapIterator<K, V>
    implements TIterator<TMap.Entry<K, V>> {
        EntryIterator(TConcurrentHashMap<K, V> map) {
            super(map);
        }

        @Override
        public TMap.Entry<K, V> next() {
            this.makeNext();
            return this.currentEntry;
        }
    }

    private static class AbstractMapIterator<K, V> {
        private int position;
        int expectedModCount;
        HashEntry<K, V> futureEntry;
        HashEntry<K, V> currentEntry;
        HashEntry<K, V> prevEntry;
        final TConcurrentHashMap<K, V> associatedMap;

        AbstractMapIterator(TConcurrentHashMap<K, V> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new TConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new TNoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new TIllegalStateException();
            }
            if (this.prevEntry == null) {
                int index = this.currentEntry.origKeyHash & this.associatedMap.elementData.length - 1;
                this.associatedMap.elementData[index] = this.associatedMap.elementData[index].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }
}

