/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.util.Arrays;
import org.teavm.classlib.impl.unicode.CLDRHelper;
import org.teavm.classlib.java.io.TSerializable;
import org.teavm.classlib.java.lang.TCloneable;
import org.teavm.classlib.java.lang.TString;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.metadata.StringResource;

public final class TLocale
implements TCloneable,
TSerializable {
    private static TLocale defaultLocale;
    public static final TLocale CANADA;
    public static final TLocale CANADA_FRENCH;
    public static final TLocale CHINA;
    public static final TLocale CHINESE;
    public static final TLocale ENGLISH;
    public static final TLocale FRANCE;
    public static final TLocale FRENCH;
    public static final TLocale GERMAN;
    public static final TLocale GERMANY;
    public static final TLocale ITALIAN;
    public static final TLocale ITALY;
    public static final TLocale JAPAN;
    public static final TLocale JAPANESE;
    public static final TLocale KOREA;
    public static final TLocale KOREAN;
    public static final TLocale PRC;
    public static final TLocale SIMPLIFIED_CHINESE;
    public static final TLocale TAIWAN;
    public static final TLocale TRADITIONAL_CHINESE;
    public static final TLocale UK;
    public static final TLocale US;
    public static final TLocale ROOT;
    private static TLocale[] availableLocales;
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;

    public TLocale(String language) {
        this(language, "", "");
    }

    public TLocale(String language, String country) {
        this(language, country, "");
    }

    public TLocale(String language, String country, String variant) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        if (language.isEmpty() && country.isEmpty()) {
            this.languageCode = "";
            this.countryCode = "";
            this.variantCode = variant;
            return;
        }
        this.languageCode = language;
        this.countryCode = country;
        this.variantCode = variant;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TLocale) {
            TLocale o = (TLocale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode);
        }
        return false;
    }

    public static TLocale[] getAvailableLocales() {
        if (availableLocales == null) {
            ResourceArray<StringResource> strings = CLDRHelper.getAvailableLocales();
            availableLocales = new TLocale[strings.size()];
            for (int i = 0; i < strings.size(); ++i) {
                String string = ((StringResource)strings.get(i)).getValue();
                int countryIndex = string.indexOf(45);
                TLocale.availableLocales[i] = countryIndex > 0 ? new TLocale(string.substring(0, countryIndex), string.substring(countryIndex + 1)) : new TLocale(string);
            }
        }
        return Arrays.copyOf(availableLocales, availableLocales.length);
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static TLocale getDefault() {
        return defaultLocale;
    }

    public String getDisplayCountry() {
        return this.getDisplayCountry(TLocale.getDefault());
    }

    public String getDisplayCountry(TLocale locale) {
        String result = TLocale.getDisplayCountry(locale.getLanguage() + "-" + locale.getCountry(), this.countryCode);
        if (result == null) {
            result = TLocale.getDisplayCountry(locale.getLanguage(), this.countryCode);
        }
        return result != null ? result : this.countryCode;
    }

    private static String getDisplayCountry(String localeName, String country) {
        if (!CLDRHelper.getCountriesMap().has(localeName)) {
            return null;
        }
        ResourceMap countries = (ResourceMap)CLDRHelper.getCountriesMap().get(localeName);
        if (!countries.has(country)) {
            return null;
        }
        return ((StringResource)countries.get(country)).getValue();
    }

    public String getDisplayLanguage() {
        return this.getDisplayLanguage(TLocale.getDefault());
    }

    public String getDisplayLanguage(TLocale locale) {
        String result = TLocale.getDisplayLanguage(locale.getLanguage() + "-" + locale.getCountry(), this.languageCode);
        if (result == null) {
            result = TLocale.getDisplayLanguage(locale.getLanguage(), this.languageCode);
        }
        return result != null ? result : this.languageCode;
    }

    private static String getDisplayLanguage(String localeName, String language) {
        if (!CLDRHelper.getLanguagesMap().has(localeName)) {
            return null;
        }
        ResourceMap languages = (ResourceMap)CLDRHelper.getLanguagesMap().get(localeName);
        if (!languages.has(language)) {
            return null;
        }
        return ((StringResource)languages.get(language)).getValue();
    }

    public String getDisplayName() {
        return this.getDisplayName(TLocale.getDefault());
    }

    public String getDisplayName(TLocale locale) {
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        if (!this.languageCode.isEmpty()) {
            buffer.append(this.getDisplayLanguage(locale));
            ++count;
        }
        if (!this.countryCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append(this.getDisplayCountry(locale));
            ++count;
        }
        if (!this.variantCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            buffer.append(this.getDisplayVariant(locale));
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public String getDisplayVariant() {
        return this.getDisplayVariant(TLocale.getDefault());
    }

    public String getDisplayVariant(TLocale locale) {
        return locale.getVariant();
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode();
    }

    public static void setDefault(TLocale locale) {
        if (locale == null) {
            throw new NullPointerException();
        }
        defaultLocale = locale;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.languageCode);
        if (!this.countryCode.isEmpty()) {
            result.append('_');
            result.append(this.countryCode);
        }
        if (!this.variantCode.isEmpty() && result.length() > 0) {
            if (this.countryCode.isEmpty()) {
                result.append("__");
            } else {
                result.append('_');
            }
            result.append(this.variantCode);
        }
        return result.toString();
    }

    public TString toLanguageTag() {
        StringBuilder result = new StringBuilder();
        result.append(this.languageCode.isEmpty() ? "und" : this.languageCode);
        if (!this.countryCode.isEmpty()) {
            result.append('-');
            result.append(this.countryCode);
        }
        if (!this.variantCode.isEmpty() && result.length() > 0) {
            result.append('-');
            result.append(this.variantCode);
        }
        return new TString(result.toString().toCharArray());
    }

    static {
        CANADA = new TLocale("en", "CA");
        CANADA_FRENCH = new TLocale("fr", "CA");
        CHINA = new TLocale("zh", "CN");
        CHINESE = new TLocale("zh", "");
        ENGLISH = new TLocale("en", "");
        FRANCE = new TLocale("fr", "FR");
        FRENCH = new TLocale("fr", "");
        GERMAN = new TLocale("de", "");
        GERMANY = new TLocale("de", "DE");
        ITALIAN = new TLocale("it", "");
        ITALY = new TLocale("it", "IT");
        JAPAN = new TLocale("ja", "JP");
        JAPANESE = new TLocale("ja", "");
        KOREA = new TLocale("ko", "KR");
        KOREAN = new TLocale("ko", "");
        PRC = new TLocale("zh", "CN");
        SIMPLIFIED_CHINESE = new TLocale("zh", "CN");
        TAIWAN = new TLocale("zh", "TW");
        TRADITIONAL_CHINESE = new TLocale("zh", "TW");
        UK = new TLocale("en", "GB");
        US = new TLocale("en", "US");
        ROOT = new TLocale("", "");
        String localeName = CLDRHelper.getDefaultLocale().getValue();
        int countryIndex = localeName.indexOf(95);
        defaultLocale = new TLocale(localeName.substring(0, countryIndex), localeName.substring(countryIndex + 1), "");
    }
}

