/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteBufferNative;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TJSBufferHelper;
import org.teavm.classlib.java.nio.TLongBuffer;
import org.teavm.classlib.java.nio.TLongBufferImpl;
import org.teavm.classlib.java.nio.TNativeBufferObjectMarker;
import org.teavm.interop.Address;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.BigInt64Array;

class TLongBufferNative
extends TLongBufferImpl
implements TArrayBufferViewProvider {
    Object gcRef;
    long[] array;
    boolean readOnly;
    @TNativeBufferObjectMarker
    protected final Object base;
    Address address;
    int capacity;
    boolean swap;

    TLongBufferNative(Object gcRef, long[] array, int position, int limit, boolean readOnly, Object base, Address address, int capacity, boolean swap) {
        super(position, limit);
        this.gcRef = gcRef;
        this.array = array;
        this.readOnly = readOnly;
        this.base = base;
        this.address = address;
        this.capacity = capacity;
        this.swap = swap;
    }

    @Override
    int capacityImpl() {
        return this.capacity;
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    long[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return (int)(this.address.diff(Address.ofData((long[])this.array)) / 8L);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.base == null;
    }

    @Override
    TLongBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        return new TLongBufferNative(this.gcRef, this.array, position, limit, readOnly, this.base, this.address.add(start * 8), capacity, this.swap);
    }

    @Override
    long getElement(int index) {
        long result = this.address.add(index * 8).getLong();
        return this.swap ? Long.reverseBytes(result) : result;
    }

    @Override
    void putElement(int index, long value) {
        this.address.add(index * 8).putLong(this.swap ? Long.reverseBytes(value) : value);
    }

    @Override
    void getImpl(int index, long[] dst, int offset, int length) {
        Address addr = this.address.add(index * 8);
        if (this.swap) {
            while (length-- > 0) {
                dst[offset++] = Long.reverseBytes(addr.getLong());
                addr = addr.add(8);
            }
        } else {
            this.copy(addr, dst, offset, length);
        }
    }

    @Override
    void putImpl(int index, long[] src, int offset, int length) {
        Address addr = this.address.add(index * 8);
        if (this.swap) {
            while (length-- > 0) {
                addr.putLong(Long.reverseBytes(src[offset++]));
                addr = addr.add(8);
            }
        } else {
            this.copy(src, offset, addr, length);
        }
    }

    @Override
    void putImpl(int index, TLongBuffer src, int offset, int length) {
        if (src instanceof TLongBufferNative) {
            TLongBufferNative srcImpl = (TLongBufferNative)src;
            Address addr = this.address.add(index * 8);
            if (srcImpl.swap == this.swap) {
                TByteBufferNative.copy(srcImpl.address.add(offset * 8), addr, length * 8);
            } else {
                Address srcAddr = srcImpl.address.add(offset * 8);
                while (length-- > 0) {
                    addr.putLong(Long.reverseBytes(srcAddr.getLong()));
                    addr = addr.add(8);
                    srcAddr = srcAddr.add(8);
                }
            }
        } else {
            Address addr = this.address.add(index * 8);
            if (this.swap) {
                while (length-- > 0) {
                    addr.putLong(Long.reverseBytes(src.get(offset++)));
                    addr = addr.add(8);
                }
            } else {
                while (length-- > 0) {
                    addr.putLong(src.get(offset++));
                    addr = addr.add(8);
                }
            }
        }
    }

    @Override
    public TByteOrder order() {
        return this.swap ? TByteBufferNative.oppositeOrder(TByteOrder.nativeOrder()) : TByteOrder.nativeOrder();
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return new BigInt64Array(TJSBufferHelper.WasmGC.getLinearMemory(), this.address.toInt(), this.capacity);
    }

    @Override
    public int elementSize() {
        return 8;
    }

    void copy(long[] from, int fromOffset, Address to, int count) {
        TByteBufferNative.copy(Address.ofData((long[])from).add(fromOffset * 8), to, count * 8);
    }

    void copy(Address from, long[] to, int toOffset, int count) {
        TByteBufferNative.copy(from, Address.ofData((long[])to).add(toOffset * 8), count * 8);
    }
}

