/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TIntBuffer;
import org.teavm.classlib.java.nio.TIntBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.Int32Array;

class TIntBufferOverTypedArray
extends TIntBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private Int32Array data;
    private int[] array;

    TIntBufferOverTypedArray(int position, int limit, boolean readOnly, Int32Array data, int[] array) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.array = array;
    }

    @Override
    TIntBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        Int32Array slice = new Int32Array(this.data.getBuffer(), this.data.getByteOffset() + start * 4, capacity);
        return new TIntBufferOverTypedArray(position, limit, readOnly, slice, this.array);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    int getElement(int index) {
        return this.data.get(index);
    }

    @Override
    void putElement(int index, int value) {
        this.data.set(index, value);
    }

    @Override
    boolean isArrayPresent() {
        return this.array != null;
    }

    @Override
    int[] getArray() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.array;
    }

    @Override
    int getArrayOffset() {
        if (this.array == null) {
            throw new UnsupportedOperationException();
        }
        return this.data.getByteOffset() / 4;
    }

    @Override
    public TByteOrder order() {
        return TByteOrder.nativeOrder();
    }

    @Override
    int capacityImpl() {
        return this.data.getLength();
    }

    @Override
    void getImpl(int index, int[] dst, int offset, int length) {
        Int32Array slice = new Int32Array(this.data.getBuffer(), this.data.getByteOffset() + index * 4, length);
        Int32Array.fromJavaArray((int[])dst).set((ArrayBufferView)slice, offset);
    }

    @Override
    void putImpl(int index, int[] src, int offset, int length) {
        Int32Array slice = new Int32Array(Int32Array.fromJavaArray((int[])src).getBuffer(), offset * 4, length);
        this.data.set((ArrayBufferView)slice, index);
    }

    @Override
    void putImpl(int index, TIntBuffer src, int offset, int length) {
        if (src instanceof TIntBufferOverTypedArray) {
            TIntBufferOverTypedArray srcImpl = (TIntBufferOverTypedArray)src;
            Int32Array slice = new Int32Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + index * 4, length);
            this.data.set((ArrayBufferView)slice, index);
        } else {
            while (length-- > 0) {
                this.data.set(index++, src.get(offset++));
            }
        }
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 4;
    }
}

