/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.nio;

import org.teavm.classlib.java.nio.TArrayBufferViewProvider;
import org.teavm.classlib.java.nio.TByteOrder;
import org.teavm.classlib.java.nio.TCharBuffer;
import org.teavm.classlib.java.nio.TCharBufferImpl;
import org.teavm.jso.typedarrays.ArrayBufferView;
import org.teavm.jso.typedarrays.DataView;
import org.teavm.jso.typedarrays.Int8Array;

class TCharBufferOverDataView
extends TCharBufferImpl
implements TArrayBufferViewProvider {
    private boolean readOnly;
    private DataView data;
    private boolean littleEndian;

    TCharBufferOverDataView(int position, int limit, boolean readOnly, DataView data, boolean littleEndian) {
        super(position, limit);
        this.readOnly = readOnly;
        this.data = data;
        this.littleEndian = littleEndian;
    }

    @Override
    TCharBuffer duplicate(int start, int capacity, int position, int limit, boolean readOnly) {
        DataView slice = new DataView(this.data.getBuffer(), this.data.getByteOffset() + start * 2, capacity * 2);
        return new TCharBufferOverDataView(position, limit, readOnly, slice, this.littleEndian);
    }

    @Override
    boolean readOnly() {
        return this.readOnly;
    }

    @Override
    char getChar(int index) {
        return (char)this.data.getUint16(index * 2, this.littleEndian);
    }

    @Override
    void putChar(int index, char value) {
        this.data.setUint16(index * 2, (int)value, this.littleEndian);
    }

    @Override
    void getImpl(int index, char[] dst, int offset, int length) {
        index *= 2;
        while (length-- > 0) {
            dst[offset++] = (char)this.data.getUint16(index, this.littleEndian);
            index += 2;
        }
    }

    @Override
    void putImpl(int index, TCharBuffer src, int offset, int length) {
        if (src instanceof TCharBufferOverDataView) {
            TCharBufferOverDataView srcImpl = (TCharBufferOverDataView)src;
            Int8Array srcArray = new Int8Array(srcImpl.data.getBuffer(), srcImpl.data.getByteOffset() + offset * 2, length *= 2);
            Int8Array destArray = new Int8Array(this.data.getBuffer(), this.data.getByteOffset() + index * 2, length);
            destArray.set((ArrayBufferView)srcArray, 0);
        } else {
            index *= 2;
            while (length-- > 0) {
                this.data.setUint16(index, (int)src.get(offset++), this.littleEndian);
                index += 2;
            }
        }
    }

    @Override
    void putImpl(int index, char[] src, int offset, int length) {
        index *= 2;
        while (length-- > 0) {
            this.data.setUint16(index, (int)src[offset++], this.littleEndian);
            index += 2;
        }
    }

    @Override
    void putImpl(int index, String src, int offset, int length) {
        index *= 2;
        while (length-- > 0) {
            this.data.setUint16(index, (int)src.charAt(offset++), this.littleEndian);
            index += 2;
        }
    }

    @Override
    boolean isArrayPresent() {
        return false;
    }

    @Override
    char[] getArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    int getArrayOffset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public TByteOrder order() {
        return this.littleEndian ? TByteOrder.LITTLE_ENDIAN : TByteOrder.BIG_ENDIAN;
    }

    @Override
    int capacityImpl() {
        return this.data.getByteLength() / 2;
    }

    @Override
    public ArrayBufferView getArrayBufferView() {
        return this.data;
    }

    @Override
    public int elementSize() {
        return 2;
    }
}

