/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.teavm.classlib.java.io.TCloseable;
import org.teavm.classlib.java.lang.TObject;

public abstract class TInputStream
extends TObject
implements TCloseable {
    private static final int BUFFER_SIZE = 2048;

    public abstract int read() throws IOException;

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            int bt = this.read();
            if (bt < 0) {
                return i == 0 ? -1 : i;
            }
            b[off++] = (byte)bt;
        }
        return len > 0 ? len : -1;
    }

    public long skip(long n) throws IOException {
        if (n < Integer.MAX_VALUE) {
            return this.skip((int)n);
        }
        for (long i = 0L; i < n; ++i) {
            if (this.read() >= 0) continue;
            return i;
        }
        return n;
    }

    private int skip(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            if (this.read() >= 0) continue;
            return i;
        }
        return n;
    }

    public int available() throws IOException {
        return 0;
    }

    @Override
    public void close() throws IOException {
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException();
    }

    public boolean markSupported() {
        return false;
    }

    public byte[] readAllBytes() throws IOException {
        return this.readNBytes(Integer.MAX_VALUE);
    }

    public byte[] readNBytes(int len) throws IOException {
        int bytesToRead;
        int bytesRead;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return new byte[0];
        }
        ArrayList<byte[]> buffers = null;
        byte[] buffer = new byte[2048];
        int positionInBuffer = 0;
        int totalBytesRead = 0;
        while ((bytesRead = this.read(buffer, positionInBuffer, bytesToRead = Math.min(buffer.length - positionInBuffer, len - totalBytesRead))) >= 0) {
            positionInBuffer += bytesRead;
            if ((totalBytesRead += bytesRead) == len) break;
            if (positionInBuffer * 2 <= buffer.length) continue;
            if (buffers == null) {
                buffers = new ArrayList<byte[]>();
            }
            buffers.add(Arrays.copyOf(buffer, positionInBuffer));
            positionInBuffer = 0;
        }
        if (buffers == null) {
            return positionInBuffer == buffer.length ? buffer : Arrays.copyOf(buffer, positionInBuffer);
        }
        byte[] result = new byte[totalBytesRead];
        int ptr = 0;
        for (byte[] part : buffers) {
            System.arraycopy(part, 0, result, ptr, part.length);
            ptr += part.length;
        }
        if (positionInBuffer > 0) {
            System.arraycopy(buffer, 0, result, ptr, positionInBuffer);
        }
        return result;
    }

    public int readNBytes(byte[] b, int off, int len) throws IOException {
        int bytesRead;
        if (off < 0 || len < 0 || off + len >= b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int initialLen = len;
        while ((bytesRead = this.read(b, off, len)) >= 0) {
            off += bytesRead;
            len -= bytesRead;
        }
        return initialLen - len;
    }

    public void skipNBytes(long n) throws IOException {
        if (n < 0L) {
            throw new IndexOutOfBoundsException();
        }
        while (n > 0L) {
            long bytesSkipped = this.skip(n);
            if (bytesSkipped < 0L) {
                throw new IOException();
            }
            if ((n -= bytesSkipped) == 0L) break;
            if (n >= 0L) continue;
            throw new IOException();
        }
    }

    public long transferTo(OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[2048];
        long bytesTransferred = 0L;
        while ((bytesRead = this.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
            bytesTransferred += (long)bytesRead;
        }
        return bytesTransferred;
    }

    public static TInputStream nullInputStream() {
        return new TInputStream(){
            private boolean closed;

            @Override
            public void close() {
                this.closed = true;
            }

            @Override
            public int read() throws IOException {
                this.checkOpen();
                return -1;
            }

            @Override
            public int read(byte[] b) throws IOException {
                this.checkOpen();
                return -1;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkOpen();
                return -1;
            }

            @Override
            public byte[] readAllBytes() throws IOException {
                this.checkOpen();
                return new byte[0];
            }

            @Override
            public byte[] readNBytes(int len) throws IOException {
                this.checkOpen();
                return new byte[0];
            }

            @Override
            public long skip(long n) throws IOException {
                this.checkOpen();
                if (n > 0L) {
                    throw new IOException();
                }
                if (n < 0L) {
                    throw new IndexOutOfBoundsException();
                }
                return 0L;
            }

            @Override
            public void skipNBytes(long n) throws IOException {
                if (n > 0L) {
                    throw new IOException();
                }
            }

            private void checkOpen() throws IOException {
                if (this.closed) {
                    throw new IOException();
                }
            }
        };
    }
}

