/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.teavm.classlib.java.io.TFile;
import org.teavm.runtime.fs.VirtualFile;
import org.teavm.runtime.fs.VirtualFileAccessor;

public class TFileOutputStream
extends OutputStream {
    private static final byte[] ONE_BYTE_BUFER = new byte[1];
    private VirtualFileAccessor accessor;

    public TFileOutputStream(TFile file) throws FileNotFoundException {
        this(file, false);
    }

    public TFileOutputStream(String path) throws FileNotFoundException {
        this(new TFile(path));
    }

    public TFileOutputStream(String path, boolean append) throws FileNotFoundException {
        this(new TFile(path), append);
    }

    public TFileOutputStream(TFile file, boolean append) throws FileNotFoundException {
        VirtualFile virtualFile;
        if (file.getName().isEmpty()) {
            throw new FileNotFoundException("Invalid file name");
        }
        VirtualFile parentVirtualFile = file.findParentFile();
        if (parentVirtualFile != null && parentVirtualFile.isDirectory()) {
            try {
                parentVirtualFile.createFile(file.getName());
            }
            catch (IOException e) {
                throw new FileNotFoundException();
            }
        }
        if ((virtualFile = file.findVirtualFile()) == null || !virtualFile.isFile()) {
            throw new FileNotFoundException("Could not create file");
        }
        this.accessor = virtualFile.createAccessor(false, true, append);
        if (this.accessor == null) {
            throw new FileNotFoundException();
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Objects.requireNonNull(b);
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureOpened();
        this.accessor.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.ensureOpened();
        this.accessor.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.accessor != null) {
            this.accessor.close();
        }
        this.accessor = null;
    }

    @Override
    public void write(int b) throws IOException {
        this.ensureOpened();
        byte[] buffer = ONE_BYTE_BUFER;
        buffer[0] = (byte)b;
        this.accessor.write(buffer, 0, 1);
    }

    private void ensureOpened() throws IOException {
        if (this.accessor == null) {
            throw new IOException("This stream is already closed");
        }
    }
}

