/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.console;

import org.teavm.backend.c.intrinsic.RuntimeInclude;
import org.teavm.backend.wasm.runtime.WasmSupport;
import org.teavm.backend.wasm.runtime.gc.WasmGCSupport;
import org.teavm.classlib.PlatformDetector;
import org.teavm.interop.Address;
import org.teavm.interop.Import;
import org.teavm.interop.Unmanaged;
import org.teavm.jso.JSBody;

public final class Console {
    private Console() {
    }

    public static void writeStderr(byte[] data, int off, int len) {
        if (PlatformDetector.isC()) {
            for (int i = 0; i < len; ++i) {
                byte b = data[i + off];
                Console.writeC(b & 0xFF);
            }
        } else if (PlatformDetector.isWebAssembly()) {
            WasmSupport.putCharsStderr((Address)Address.ofData((byte[])data).add(off), (int)len);
        } else if (PlatformDetector.isWebAssemblyGC()) {
            for (int i = 0; i < len; ++i) {
                WasmGCSupport.putCharStderr((char)((char)data[off + i]));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                byte b = data[i + off];
                Console.writeJs(b & 0xFF);
            }
        }
    }

    public static void writeStdout(byte[] data, int off, int len) {
        if (PlatformDetector.isC()) {
            for (int i = 0; i < len; ++i) {
                byte b = data[i + off];
                Console.writeC(b & 0xFF);
            }
        } else if (PlatformDetector.isWebAssembly()) {
            WasmSupport.putCharsStdout((Address)Address.ofData((byte[])data).add(off), (int)len);
        } else if (PlatformDetector.isWebAssemblyGC()) {
            for (int i = 0; i < len; ++i) {
                WasmGCSupport.putCharStdout((char)((char)data[off + i]));
            }
        } else {
            for (int i = 0; i < len; ++i) {
                byte b = data[i + off];
                Console.writeJsStdout(b & 0xFF);
            }
        }
    }

    @JSBody(params={"b"}, script="$rt_putStderr(b);")
    private static native void writeJs(int var0);

    @JSBody(params={"b"}, script="$rt_putStdout(b);")
    private static native void writeJsStdout(int var0);

    @Unmanaged
    @Import(name="teavm_logchar")
    @RuntimeInclude(value="log.h")
    private static native void writeC(int var0);
}

