/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.util;

import java.io.IOException;
import org.teavm.codegen.SourceWriter;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.javascript.ni.Generator;
import org.teavm.javascript.ni.GeneratorContext;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class TimerNativeGenerator
implements Generator,
DependencyPlugin {
    private static final MethodReference performOnceRef = new MethodReference("java.util.TimerTask", "performOnce", new ValueType[]{ValueType.VOID});

    public void methodAchieved(DependencyChecker checker, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "scheduleOnce": {
                MethodDependency performMethod = checker.linkMethod(performOnceRef, method.getStack());
                method.getVariable(1).connect(performMethod.getVariable(1));
                break;
            }
        }
    }

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "scheduleOnce": {
                this.generateScheduleNative(context, writer);
            }
        }
    }

    private void generateScheduleNative(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("return setTimeout(function() {").indent().softNewLine();
        writer.append(context.getParameterName(1)).append(".").appendMethod(performOnceRef).append("();").softNewLine();
        writer.outdent().append("},").ws().append(context.getParameterName(2)).append(");").softNewLine();
    }
}

