/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.java.lang;

import org.teavm.classlib.java.lang.TClass;
import org.teavm.classlib.java.lang.TComparable;
import org.teavm.classlib.java.lang.TInteger;
import org.teavm.classlib.java.lang.TNumber;
import org.teavm.classlib.java.lang.TNumberFormatException;
import org.teavm.classlib.java.lang.TObject;
import org.teavm.classlib.java.lang.TString;
import org.teavm.javascript.ni.Rename;

public class TShort
extends TNumber
implements TComparable<TShort> {
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final TClass<TShort> TYPE = TClass.shortClass();
    public static final int SIZE = 16;
    private short value;

    public TShort(short value) {
        this.value = value;
    }

    public TShort(TString s) throws TNumberFormatException {
        this(TShort.parseShort(s));
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public static TShort valueOf(short value) {
        return new TShort(value);
    }

    public static TString toString(short value) {
        return TString.wrap("" + value);
    }

    @Override
    @Rename(value="toString")
    public TString toString0() {
        return TShort.toString(this.value);
    }

    @Override
    public boolean equals(TObject other) {
        return other instanceof TShort && ((TShort)other).value == this.value;
    }

    @Override
    public int hashCode() {
        return this.value;
    }

    public static int compare(short a, short b) {
        return a - b;
    }

    @Override
    public int compareTo(TShort other) {
        return TShort.compare(this.value, other.value);
    }

    public static short parseShort(TString s, int radix) throws TNumberFormatException {
        int value = TInteger.parseInt(s, radix);
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new TNumberFormatException();
        }
        return (short)value;
    }

    public static short parseShort(TString s) throws TNumberFormatException {
        return TShort.parseShort(s, 10);
    }

    public static TShort valueOf(TString s, int radix) throws TNumberFormatException {
        return TShort.valueOf(TShort.parseShort(s, radix));
    }

    public static TShort valueOf(TString s) throws TNumberFormatException {
        return TShort.valueOf(TShort.parseShort(s));
    }

    public static TShort decode(TString s) throws TNumberFormatException {
        int value = TInteger.decode(s).intValue();
        if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
            throw new TNumberFormatException();
        }
        return TShort.valueOf((short)value);
    }

    public static short reverseBytes(short i) {
        return (short)(i << 8 | i >>> 8);
    }
}

