/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl.report;

import java.util.Map;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.teavm.classlib.impl.report.JCLClass;
import org.teavm.classlib.impl.report.JCLClassType;
import org.teavm.classlib.impl.report.JCLItem;
import org.teavm.classlib.impl.report.JCLItemType;
import org.teavm.classlib.impl.report.JCLPackage;
import org.teavm.classlib.impl.report.JCLStatus;
import org.teavm.classlib.impl.report.JCLVisibility;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;

class JCLComparisonVisitor
extends ClassVisitor {
    private Map<String, JCLPackage> packageMap;
    private ClassReaderSource classSource;
    private ClassReader classReader;
    private JCLPackage jclPackage;
    private JCLClass jclClass;

    public JCLComparisonVisitor(ClassReaderSource classSource, Map<String, JCLPackage> packageMap) {
        super(262144);
        this.classSource = classSource;
        this.packageMap = packageMap;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if ((access & 5) == 0) {
            this.jclClass = null;
            this.classReader = null;
            return;
        }
        String javaName = name.replace('/', '.');
        int dotIndex = javaName.lastIndexOf(46);
        String packageName = javaName.substring(0, dotIndex);
        String simpleName = javaName.substring(dotIndex + 1);
        this.jclPackage = this.packageMap.get(packageName);
        if (this.jclPackage == null) {
            this.jclPackage = new JCLPackage(packageName);
            this.jclPackage.status = JCLStatus.FOUND;
            this.packageMap.put(packageName, this.jclPackage);
        }
        this.classReader = this.classSource.get(javaName);
        this.jclClass = new JCLClass(simpleName);
        this.jclClass.status = this.classReader != null ? JCLStatus.FOUND : JCLStatus.MISSING;
        JCLVisibility jCLVisibility = this.jclClass.visibility = (access & 4) != 0 ? JCLVisibility.PROTECTED : JCLVisibility.PUBLIC;
        this.jclClass.type = (access & 0x2000) != 0 ? JCLClassType.ANNOTATION : ((access & 0x200) != 0 ? JCLClassType.INTERFACE : ((access & 0x4000) != 0 ? JCLClassType.ENUM : JCLClassType.CLASS));
        this.jclPackage.classes.add(this.jclClass);
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.classReader == null || (access & 5) == 0) {
            return null;
        }
        JCLItem item = new JCLItem(JCLItemType.FIELD, name + ":" + desc);
        FieldReader field = this.classReader.getField(name);
        item.status = field != null ? JCLStatus.FOUND : JCLStatus.MISSING;
        item.visibility = (access & 4) != 0 ? JCLVisibility.PROTECTED : JCLVisibility.PUBLIC;
        this.jclClass.items.add(item);
        if (item.status == JCLStatus.MISSING) {
            this.jclClass.status = JCLStatus.PARTIAL;
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.classReader == null || (access & 5) == 0) {
            return null;
        }
        JCLItem item = new JCLItem(JCLItemType.METHOD, name + desc);
        MethodReader method = this.findMethod(this.classReader, MethodDescriptor.parse((String)(name + desc)));
        item.status = method == null ? JCLStatus.MISSING : ((access & 0x400) == 0 && method.hasModifier(ElementModifier.ABSTRACT) ? JCLStatus.MISSING : (method.getOwnerName().equals(this.classReader.getName()) ? JCLStatus.FOUND : JCLStatus.PARTIAL));
        item.visibility = (access & 4) != 0 ? JCLVisibility.PROTECTED : JCLVisibility.PUBLIC;
        this.jclClass.items.add(item);
        if (item.status == JCLStatus.MISSING) {
            this.jclClass.status = JCLStatus.PARTIAL;
        }
        return null;
    }

    private MethodReader findMethod(ClassReader cls, MethodDescriptor desc) {
        ClassReader parent;
        MethodReader method = cls.getMethod(desc);
        if (method != null) {
            return method;
        }
        if (cls.getParent() != null && (parent = this.classSource.get(cls.getParent())) != null && (method = this.findMethod(parent, desc)) != null) {
            return method;
        }
        for (String ifaceName : cls.getInterfaces()) {
            ClassReader iface = this.classSource.get(ifaceName);
            if (iface == null || (method = this.findMethod(iface, desc)) == null) continue;
            return method;
        }
        return null;
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return null;
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
    }

    public void visitEnd() {
        if (this.jclClass == null || this.jclClass.status != JCLStatus.FOUND) {
            this.jclPackage.status = JCLStatus.PARTIAL;
        }
    }
}

