/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class NewInstanceDependencySupport
implements DependencyListener {
    private DependencyNode allClassesNode;
    private DependencyStack newInstanceStack;

    public void started(DependencyChecker dependencyChecker) {
        this.allClassesNode = dependencyChecker.createNode();
    }

    public void classAchieved(DependencyChecker dependencyChecker, String className) {
        ClassReader cls = dependencyChecker.getClassSource().get(className);
        if (cls == null) {
            return;
        }
        if (cls.hasModifier(ElementModifier.ABSTRACT) || cls.hasModifier(ElementModifier.INTERFACE)) {
            return;
        }
        MethodReader method = cls.getMethod(new MethodDescriptor("<init>", new ValueType[]{ValueType.VOID}));
        if (method != null) {
            this.allClassesNode.propagate(className);
        }
    }

    public void methodAchieved(final DependencyChecker dependencyChecker, MethodDependency method) {
        MethodReader reader = method.getMethod();
        if (reader.getOwnerName().equals("java.lang.Class") && reader.getName().equals("newInstance")) {
            this.newInstanceStack = method.getStack();
            this.allClassesNode.connect(method.getResult());
            method.getResult().addConsumer(new DependencyConsumer(){

                public void consume(String type) {
                    NewInstanceDependencySupport.this.attachConstructor(dependencyChecker, type);
                }
            });
        }
    }

    private void attachConstructor(DependencyChecker checker, String type) {
        MethodReference ref = new MethodReference(type, new MethodDescriptor("<init>", new ValueType[]{ValueType.VOID}));
        checker.linkMethod(ref, this.newInstanceStack).use();
    }

    public void fieldAchieved(DependencyChecker dependencyChecker, FieldDependency field) {
    }
}

