/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.classlib.impl;

import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyListener;
import org.teavm.dependency.DependencyNode;
import org.teavm.dependency.DependencyStack;
import org.teavm.dependency.FieldDependency;
import org.teavm.dependency.MethodDependency;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ClassLookupDependencySupport
implements DependencyListener {
    private DependencyNode allClasses;

    public void started(DependencyChecker dependencyChecker) {
        this.allClasses = dependencyChecker.createNode();
    }

    public void classAchieved(DependencyChecker dependencyChecker, String className) {
        this.allClasses.propagate(className);
    }

    public void methodAchieved(final DependencyChecker dependencyChecker, MethodDependency method) {
        MethodReference ref = method.getReference();
        if (ref.getClassName().equals("java.lang.Class") && ref.getName().equals("forNameImpl")) {
            final DependencyStack stack = method.getStack();
            this.allClasses.addConsumer(new DependencyConsumer(){

                public void consume(String type) {
                    ClassReader cls = dependencyChecker.getClassSource().get(type);
                    if (cls == null) {
                        return;
                    }
                    MethodReader initMethod = cls.getMethod(new MethodDescriptor("<clinit>", new ValueType[]{ValueType.VOID}));
                    if (initMethod != null) {
                        dependencyChecker.linkMethod(initMethod.getReference(), stack).use();
                    }
                }
            });
        }
    }

    public void fieldAchieved(DependencyChecker dependencyChecker, FieldDependency field) {
    }
}

