/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.source;

import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.talend.runtime.documentation.component.configuration.TableDataSet;
import org.talend.runtime.documentation.component.messages.Messages;
import org.talend.runtime.documentation.component.service.http.TableApiClient;
import org.talend.sdk.component.api.base.BufferizedProducerSupport;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.input.Producer;

public class MockTableSource
implements Serializable {
    private final TableDataSet ds;
    private final Messages i18n;
    private BufferizedProducerSupport<JsonValue> bufferedReader;
    private TableApiClient tableAPI;

    public MockTableSource(@Option(value="ds") TableDataSet ds, Messages i18n, TableApiClient tableAPI) {
        this.ds = ds;
        this.i18n = i18n;
        this.tableAPI = tableAPI;
    }

    @PostConstruct
    public void init() {
        this.tableAPI.base(this.ds.getDataStore().getUrlWithSlashEnding() + "api/now" + "/" + "v2");
        this.bufferedReader = new BufferizedProducerSupport(() -> {
            if (this.ds.getMaxRecords() != -1 && this.ds.getOffset() >= this.ds.getMaxRecords()) {
                return null;
            }
            JsonArray result = this.tableAPI.getRecords(this.ds.getCommonConfig().getTableName().name(), this.ds.getDataStore().getAuthorizationHeader(), this.ds.buildQuery(), this.ds.getCommonConfig().getFieldsCommaSeparated(), this.ds.getOffset(), this.evalLimit(this.ds));
            if (this.ds.getOffset() < this.ds.getMaxRecords()) {
                this.ds.setOffset(this.ds.getOffset() + this.ds.getPageSize());
            }
            return result.iterator();
        });
    }

    private int evalLimit(TableDataSet ds) {
        return ds.getOffset() + ds.getPageSize() <= ds.getMaxRecords() ? ds.getPageSize() : ds.getMaxRecords();
    }

    @Producer
    public JsonObject next() {
        JsonValue next = (JsonValue)this.bufferedReader.next();
        return next == null ? null : next.asJsonObject();
    }
}

