/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.service.http;

import java.util.List;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.talend.runtime.documentation.component.configuration.CommonConfig;
import org.talend.runtime.documentation.component.service.http.codec.InvalidContentDecoder;
import org.talend.runtime.documentation.component.service.http.codec.RecordSizeDecoder;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.service.http.Codec;
import org.talend.sdk.component.api.service.http.Header;
import org.talend.sdk.component.api.service.http.HttpClient;
import org.talend.sdk.component.api.service.http.HttpException;
import org.talend.sdk.component.api.service.http.Path;
import org.talend.sdk.component.api.service.http.Query;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.http.Response;

public interface TableApiClient
extends HttpClient {
    public static final String API_BASE = "api/now";
    public static final String API_VERSION = "v2";
    public static final String SYSPARM_SUPPRESS_PAGINATION_HEADER = "SYSPARM_SUPPRESS_PAGINATION_HEADER";
    public static final String SYSPARM_OFFSET = "SYSPARM_OFFSET";
    public static final String SYSPARM_LIMIT = "SYSPARM_LIMIT";
    public static final String SYSPARM_EXCLUDE_REFERENCE_LINK = "SYSPARM_EXCLUDE_REFERENCE_LINK";
    public static final String SYSPARM_QUERY = "SYSPARM_QUERY";
    public static final String SYSPARM_FIELDS = "SYSPARM_FIELDS";
    public static final String X_TOTAL_COUNT = "X-Total-Count";
    public static final String X_NO_RESPONSE_BODY = "X-no-response-body";
    public static final String AUTHORIZATION = "Authorization";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";

    @Request(path="table/{tableName}")
    @Codec(decoder={InvalidContentDecoder.class})
    @Documentation(value="read record from the table according to the data set definition")
    public Response<JsonObject> get(@Path(value="tableName") String var1, @Header(value="Authorization") String var2, @Header(value="X-no-response-body") boolean var3, @Query(value="SYSPARM_QUERY") String var4, @Query(value="SYSPARM_FIELDS") String var5, @Query(value="SYSPARM_OFFSET") int var6, @Query(value="SYSPARM_LIMIT") int var7, @Query(value="SYSPARM_EXCLUDE_REFERENCE_LINK") boolean var8, @Query(value="SYSPARM_SUPPRESS_PAGINATION_HEADER") boolean var9);

    default public JsonArray getRecords(String tableName, String auth, String query, String fields, int offset, int limit) {
        Response<JsonObject> resp = this.get(tableName, auth, false, query, fields, offset, limit, true, true);
        if (resp.status() != 200) {
            throw new HttpException(resp);
        }
        JsonObject response = (JsonObject)resp.body();
        return response.getJsonArray("result");
    }

    default public int count(String tableName, String auth, String query) {
        Response<JsonObject> resp = this.get(tableName, auth, true, query, null, 0, 1, true, true);
        if (resp.status() != 200) {
            throw new HttpException(resp);
        }
        List totalCount = (List)resp.headers().get(X_TOTAL_COUNT);
        if (totalCount == null) {
            return 0;
        }
        return Integer.parseInt((String)totalCount.iterator().next());
    }

    default public void healthCheck(String auth) {
        this.getRecords(CommonConfig.Tables.incident.name(), auth, null, null, 0, 1);
    }

    @Request(path="table/{tableName}")
    @Codec(decoder={RecordSizeDecoder.class, InvalidContentDecoder.class})
    @Documentation(value="read record from the table according to the data set definition")
    public long estimateRecordSize(@Path(value="tableName") String var1, @Header(value="Authorization") String var2, @Header(value="X-no-response-body") boolean var3, @Query(value="SYSPARM_QUERY") String var4, @Query(value="SYSPARM_FIELDS") String var5, @Query(value="SYSPARM_OFFSET") int var6, @Query(value="SYSPARM_LIMIT") int var7, @Query(value="SYSPARM_EXCLUDE_REFERENCE_LINK") boolean var8, @Query(value="SYSPARM_SUPPRESS_PAGINATION_HEADER") boolean var9);

    default public long estimateRecordSize(String tableName, String auth, String query, String fields) {
        return this.estimateRecordSize(tableName, auth, false, query, fields, 0, 1, true, true);
    }

    @Request(path="table/{tableName}", method="POST")
    @Codec(decoder={InvalidContentDecoder.class})
    @Documentation(value="Create a record to table")
    public Response<JsonObject> create(@Path(value="tableName") String var1, @Header(value="Authorization") String var2, @Header(value="X-no-response-body") boolean var3, @Header(value="Content-Type") String var4, @Query(value="SYSPARM_EXCLUDE_REFERENCE_LINK") boolean var5, JsonObject var6);

    default public JsonObject create(String tableName, String auth, boolean noResponseBody, JsonObject record) {
        Response<JsonObject> resp = this.create(tableName, auth, noResponseBody, "application/json", true, record);
        if (noResponseBody) {
            return null;
        }
        if (resp.status() == 201) {
            return ((JsonObject)resp.body()).getJsonObject("result");
        }
        throw new HttpException(resp);
    }

    @Request(path="table/{tableName}/{sysId}", method="PUT")
    @Codec(decoder={InvalidContentDecoder.class})
    @Documentation(value="update a record in table using it sys_id")
    public Response<JsonObject> update(@Path(value="tableName") String var1, @Path(value="sysId") String var2, @Header(value="Authorization") String var3, @Header(value="X-no-response-body") boolean var4, @Header(value="Content-Type") String var5, @Query(value="SYSPARM_EXCLUDE_REFERENCE_LINK") boolean var6, JsonObject var7);

    default public JsonObject update(String tableName, String sysId, String auth, boolean noResponseBody, JsonObject record) {
        Response<JsonObject> resp = this.update(tableName, sysId, auth, noResponseBody, "application/json", true, record);
        if (resp.status() == 204) {
            return null;
        }
        if (resp.status() == 200) {
            return ((JsonObject)resp.body()).getJsonObject("result");
        }
        throw new HttpException(resp);
    }

    @Request(path="table/{tableName}/{sysId}", method="DELETE")
    @Codec(decoder={InvalidContentDecoder.class})
    @Documentation(value="delete a record from a table by it sys_id")
    public Response<Void> delete(@Path(value="tableName") String var1, @Path(value="sysId") String var2, @Header(value="Authorization") String var3);

    default public void deleteRecordById(String tableName, String sysId, String auth) {
        Response<Void> resp = this.delete(tableName, sysId, auth);
        if (resp.status() != 204) {
            throw new HttpException(resp);
        }
    }
}

