/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation.component.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.talend.runtime.documentation.component.configuration.BasicAuthConfig;
import org.talend.runtime.documentation.component.configuration.QueryBuilder;
import org.talend.runtime.documentation.component.configuration.TableDataSet;
import org.talend.runtime.documentation.component.messages.Messages;
import org.talend.runtime.documentation.component.service.http.TableApiClient;
import org.talend.runtime.documentation.component.source.MockTableSource;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.record.Schema;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.asyncvalidation.AsyncValidation;
import org.talend.sdk.component.api.service.asyncvalidation.ValidationResult;
import org.talend.sdk.component.api.service.cache.Cached;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Values;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.healthcheck.HealthCheckStatus;
import org.talend.sdk.component.api.service.http.HttpClient;
import org.talend.sdk.component.api.service.http.HttpException;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.http.Response;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.schema.Schema;
import org.talend.sdk.component.runtime.record.SchemaImpl;

@Service
public class MockTableService {
    @HealthCheck(value="basicAuth")
    public HealthCheckStatus healthCheck(@Option(value="basicAuth") BasicAuthConfig dt, TableApiClient client, Messages i18n) {
        client.base(dt.getUrlWithSlashEnding() + "api/now" + "/" + "v2");
        try {
            client.healthCheck(dt.getAuthorizationHeader());
        }
        catch (Exception e) {
            if (HttpException.class.isInstance(e)) {
                HttpException ex = (HttpException)((Object)HttpException.class.cast(e));
                JsonObject jError = (JsonObject)JsonObject.class.cast(ex.getResponse().error(JsonObject.class));
                String errorMessage = null;
                if (jError != null && jError.containsKey((Object)"error")) {
                    JsonObject error = ((JsonValue)jError.get((Object)"error")).asJsonObject();
                    errorMessage = error.getString("message") + " \n" + error.getString("detail");
                }
                return new HealthCheckStatus(HealthCheckStatus.Status.KO, i18n.connectionFailed(errorMessage != null && errorMessage.trim().isEmpty() ? e.getLocalizedMessage() : errorMessage));
            }
            return new HealthCheckStatus(HealthCheckStatus.Status.KO, i18n.connectionFailed(e.getLocalizedMessage()));
        }
        return new HealthCheckStatus(HealthCheckStatus.Status.OK, i18n.connectionSuccessful());
    }

    @AsyncValidation(value="urlValidation")
    public ValidationResult validateUrl(String url) {
        try {
            new URL(url);
            return new ValidationResult(ValidationResult.Status.OK, null);
        }
        catch (MalformedURLException e) {
            return new ValidationResult(ValidationResult.Status.KO, e.getMessage());
        }
    }

    @Cached
    @DynamicValues(value="GetTableFields")
    public Values getTableFields(Client client) {
        return new Values((Collection)Stream.of(QueryBuilder.Fields.values()).map(f -> new Values.Item(f.name(), f.name())).collect(Collectors.toList()));
    }

    @DiscoverSchema(value="guessTableSchema")
    public Schema guessTableSchema(TableDataSet dataSet, TableApiClient client, Messages i18n) {
        dataSet.setMaxRecords(1);
        if (dataSet.getCommonConfig() != null) {
            dataSet.getCommonConfig().setFields(null);
        }
        MockTableSource source = new MockTableSource(dataSet, i18n, client);
        source.init();
        JsonObject record = source.next();
        if (record == null || record.keySet().isEmpty()) {
            return new Schema(Collections.emptyList());
        }
        return new Schema(record.keySet().stream().map(this::buildStringEntry).collect(Collectors.toList()));
    }

    private Schema.Entry buildStringEntry(String name) {
        return new SchemaImpl.EntryImpl.BuilderImpl().withName(name).withType(Schema.Type.STRING).build();
    }

    public static interface Client
    extends HttpClient {
        @Request
        public Response<String> whataver();
    }
}

