/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteIfDifferentStream
extends FilterOutputStream {
    private static final Logger log = LoggerFactory.getLogger(WriteIfDifferentStream.class);
    private final File destination;

    public WriteIfDifferentStream(File destination) {
        super(new ByteArrayOutputStream());
        this.destination = destination;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        byte[] bytes = ((ByteArrayOutputStream)ByteArrayOutputStream.class.cast(this.out)).toByteArray();
        if (!this.destination.exists() || this.isDifferent(bytes)) {
            try (FileOutputStream out = new FileOutputStream(this.destination);){
                ((OutputStream)out).write(bytes);
            }
            log.info(this.destination + " created");
        } else {
            log.info(this.destination + " didn't change, skip rewriting");
        }
    }

    private boolean isDifferent(byte[] bytes) throws IOException {
        String target;
        String source = Files.lines(this.destination.toPath()).collect(Collectors.joining("\n")).trim();
        return !source.equals(target = new String(bytes, StandardCharsets.UTF_8).trim());
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    public String toString() {
        return this.out.toString();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }
}

