/*
 * Decompiled with CFR 0.152.
 */
package org.talend.runtime.documentation;

import crawlercommons.sitemaps.SiteMap;
import crawlercommons.sitemaps.SiteMapParser;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.runtime.documentation.WriteIfDifferentStream;

public class SearchIndexation {
    private static final Logger log = LoggerFactory.getLogger(SearchIndexation.class);

    public static void main(String[] args) throws Exception {
        JsonBuilderFactory factory = Json.createBuilderFactory(Collections.emptyMap());
        File siteMapFile = new File(args[0]);
        String latest = args[1];
        String urlMarker = "/component-runtime/";
        SiteMap siteMap = (SiteMap)SiteMap.class.cast(new SiteMapParser(false).parseSiteMap(siteMapFile.toURI().toURL()));
        ExecutorService pool = Executors.newFixedThreadPool(Integer.getInteger("talend.algolia.indexation", 256));
        List<Future> updates = siteMap.getSiteMapUrls().stream().filter(url -> {
            String externalForm = url.getUrl().toExternalForm();
            return !externalForm.contains("/all-in-one.html") && !externalForm.contains("/pdf-") && !externalForm.contains("/landing.html") && !externalForm.contains("/index.html");
        }).filter(it -> it.getUrl().toExternalForm().contains("/component-runtime/")).map(url -> pool.submit(() -> {
            String target = url.getUrl().toExternalForm();
            String path = target.substring(target.indexOf("/component-runtime/") + "/component-runtime/".length());
            File adocSource = new File(siteMapFile.getParentFile().getParentFile().getParentFile(), "src/main/antora/modules/ROOT/pages" + path.substring(path.lastIndexOf(47), path.length() - ".html".length()) + ".adoc");
            if (!adocSource.exists() || Files.readAllLines(adocSource.toPath()).stream().anyMatch(line -> line.trim().startsWith(":page-talend_skipindexation:"))) {
                return Collections.emptyList();
            }
            log.debug("Indexing {}", (Object)target);
            File relativeHtml = new File(siteMapFile.getParentFile(), path);
            try {
                Document document = Jsoup.parse((String)String.join((CharSequence)"\n", Files.readAllLines(relativeHtml.toPath())));
                if (!document.select("div > div.sect1.relatedlinks").isEmpty()) {
                    document.select("div > div.sect1.relatedlinks").first().html("");
                }
                JsonObjectBuilder builder = factory.createObjectBuilder();
                builder.add("lang", "en").add("title", SearchIndexation.extractTitle(document)).add("version", document.select("div.navigation-container").attr("data-version")).add("url", target).add("date", new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'"){
                    {
                        this.setTimeZone(TimeZone.getTimeZone("UTC"));
                    }
                }.format(url.getLastModified())).add("timestamp", url.getLastModified().getTime());
                IntStream.rangeClosed(0, 3).forEach(i -> SearchIndexation.select(document, factory, ".doc h" + (i + 1)).ifPresent(value -> builder.add("lvl" + i, value)));
                SearchIndexation.selectMeta(document, "description").ifPresent(description -> builder.add("description", description));
                SearchIndexation.selectMeta(document, "keywords").ifPresent(keywords -> builder.add("keywords", keywords));
                Elements texts = document.select(".doc p, .doc td.content, .doc th.tableblock");
                if (texts.isEmpty()) {
                    return Collections.singletonList(builder.build());
                }
                return Collections.singletonList(builder.add("text", texts.stream().map(Element::text).collect(Collector.of(() -> ((JsonBuilderFactory)factory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, new Collector.Characteristics[0]))).build());
            }
            catch (Exception e) {
                log.warn(target + ": " + e.getMessage());
                return Collections.emptyList();
            }
        })).collect(Collectors.toList());
        pool.shutdown();
        updates.forEach(f -> {
            try {
                f.get();
            }
            catch (InterruptedException | ExecutionException e) {
                log.error(e.getMessage());
            }
        });
        try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withPropertyOrderStrategy("LEXICOGRAPHICAL"));){
            Map<String, List<JsonObject>> byVersion = updates.stream().map(f -> {
                try {
                    return (List)f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new IllegalStateException(e);
                }
            }).flatMap(Collection::stream).sorted(Comparator.comparing(o -> o.getString("title"))).collect(Collectors.groupingBy(o -> o.getString("version").equals(latest) ? "latest" : o.getString("version")));
            byVersion.forEach((version, records) -> {
                File file = new File(siteMapFile.getParentFile(), "main/" + version + "/search-index.json");
                try (WriteIfDifferentStream output = new WriteIfDifferentStream(file);){
                    jsonb.toJson(records, (OutputStream)output);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                log.info("Created {}", (Object)file);
            });
        }
    }

    private static String extractTitle(Document document) {
        String title = Optional.ofNullable(document.title()).filter(t -> !t.isEmpty()).orElseGet(() -> document.getElementsByTag("h1").text());
        if (title.contains(":: ")) {
            return title.substring(title.lastIndexOf(":: ") + 2).trim();
        }
        return title;
    }

    private static Optional<String> selectMeta(Document document, String metaName) {
        return document.select("meta").stream().filter(it -> it.hasAttr("name") && it.hasAttr("content") && metaName.equals(it.attr("name"))).findFirst().map(it -> it.attr("content"));
    }

    private static Optional<JsonArrayBuilder> select(Document document, JsonBuilderFactory factory, String selector) {
        Elements select = document.select(selector);
        if (select.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(select.stream().map(Element::text).filter(s -> !s.matches("In this article|Related articles")).filter(s -> !s.isEmpty()).distinct().map(Json::createValue).collect(() -> ((JsonBuilderFactory)factory).createArrayBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll));
    }

    private SearchIndexation() {
    }
}

