/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service.http;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.talend.sdk.component.api.service.http.Decoder;
import org.talend.sdk.component.api.service.http.Header;
import org.talend.sdk.component.api.service.http.Headers;
import org.talend.sdk.component.api.service.http.HttpMethod;
import org.talend.sdk.component.api.service.http.Path;
import org.talend.sdk.component.api.service.http.Query;
import org.talend.sdk.component.api.service.http.QueryParams;
import org.talend.sdk.component.api.service.http.Url;
import org.talend.sdk.component.runtime.manager.service.http.RequestParser;
import org.talend.sdk.component.runtime.manager.service.http.codec.JAXBDecoder;
import org.talend.sdk.component.runtime.manager.service.http.codec.JAXBEncoder;

class JAXBManager {
    private volatile Map<Class<?>, JAXBContext> jaxbContexts = new HashMap();

    JAXBManager() {
    }

    void initJaxbContext(Method method) {
        Stream.concat(Stream.of(method.getGenericReturnType()), Stream.of(method.getParameters()).filter(p -> Stream.of(Path.class, Query.class, Header.class, QueryParams.class, Headers.class, HttpMethod.class, Url.class).noneMatch(p::isAnnotationPresent)).map(Parameter::getParameterizedType)).map(RequestParser::toClassType).filter(Objects::nonNull).filter(cType -> cType.isAnnotationPresent(XmlRootElement.class) || cType.isAnnotationPresent(XmlType.class)).forEach(rootElemType -> this.jaxbContexts.computeIfAbsent((Class<?>)rootElemType, k -> {
            try {
                return JAXBContext.newInstance((Class[])new Class[]{k});
            }
            catch (JAXBException e) {
                throw new IllegalStateException(e);
            }
        }));
    }

    boolean isEmpty() {
        return this.jaxbContexts.isEmpty();
    }

    JAXBEncoder newEncoder() {
        return new JAXBEncoder(this.jaxbContexts);
    }

    Decoder newDecoder() {
        return new JAXBDecoder(this.jaxbContexts);
    }
}

