/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.manager.service;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import org.talend.sdk.component.api.service.cache.LocalCache;
import org.talend.sdk.component.runtime.serialization.SerializableService;

public class LocalCacheService
implements LocalCache,
Serializable {
    private final String plugin;
    private final ConcurrentMap<String, Element> cache = new ConcurrentHashMap<String, Element>();

    public <T> T computeIfAbsent(String key, long timeoutMs, Supplier<T> value) {
        String internalKey = this.internalKey(key);
        Element element = this.cache.compute(internalKey, (k, e) -> e == null || ((Element)e).isExpired() ? new Element(value.get(), System.currentTimeMillis() + timeoutMs) : e);
        if (element == null) {
            return null;
        }
        return (T)element.value;
    }

    private String internalKey(String key) {
        return this.plugin + '@' + key;
    }

    Object writeReplace() throws ObjectStreamException {
        return new SerializableService(this.plugin, LocalCache.class.getName());
    }

    public LocalCacheService(String plugin) {
        this.plugin = plugin;
    }

    public static class Element {
        private final Object value;
        private final long endOfValidity;

        private boolean isExpired() {
            return System.currentTimeMillis() > this.endOfValidity;
        }

        public Element(Object value, long endOfValidity) {
            this.value = value;
            this.endOfValidity = endOfValidity;
        }
    }
}

