/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.environment;

import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.talend.sdk.component.junit.delegate.DelegatingRunner;
import org.talend.sdk.component.junit.environment.DecoratingEnvironmentProvider;
import org.talend.sdk.component.junit.environment.EnvironmentsConfigurationParser;

public class MultiEnvironmentsRunner
extends DelegatingRunner {
    private final EnvironmentsConfigurationParser configuration;

    public MultiEnvironmentsRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        this.configuration = new EnvironmentsConfigurationParser(testClass);
    }

    @Override
    public void run(RunNotifier notifier) {
        this.configuration.stream().forEach(e -> {
            DecoratingEnvironmentProvider dep;
            if (DecoratingEnvironmentProvider.class.isInstance(e) && !(dep = (DecoratingEnvironmentProvider)DecoratingEnvironmentProvider.class.cast(e)).isActive()) {
                notifier.fireTestFinished(Description.createTestDescription(this.getTestClass(), (String)dep.getName()));
                return;
            }
            try (AutoCloseable ignored = e.start(this.getTestClass(), this.getTestClass().getAnnotations());){
                MultiEnvironmentsRunner.super.run(notifier);
            }
            catch (Exception e1) {
                throw new IllegalStateException(e1);
            }
        });
    }
}

