/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class RecordAsserts
implements Function<Iterable<Map<String, List<Serializable>>>, Void>,
Serializable {
    private final Map<String, SerializableConsumer<List<? extends Serializable>>> validators = new HashMap<String, SerializableConsumer<List<? extends Serializable>>>();

    public <R extends Serializable> RecordAsserts withAsserts(String outputName, SerializableConsumer<List<R>> validator) {
        this.validators.put(outputName, (SerializableConsumer<List<? extends Serializable>>)SerializableConsumer.class.cast(validator));
        return this;
    }

    @Override
    public Void apply(Iterable<Map<String, List<Serializable>>> input) {
        Map<String, List> outputs = StreamSupport.stream(input.spliterator(), false).flatMap(m -> m.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u1, u2) -> Stream.of(u1, u2).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList())));
        HashSet<String> missing = new HashSet<String>(this.validators.keySet());
        missing.removeAll(outputs.keySet());
        if (!missing.isEmpty()) {
            throw new IllegalArgumentException("Missing outputs: " + missing);
        }
        this.validators.forEach((k, v) -> v.accept(outputs.get(k)));
        return null;
    }

    public static interface SerializableConsumer<A>
    extends Consumer<A>,
    Serializable {
    }
}

