/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit;

import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ExceptionVerifier<T extends RuntimeException>
implements TestRule {
    private Consumer<T> consumer;

    public void assertWith(Consumer<T> consumer) {
        this.consumer = consumer;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    base.evaluate();
                    if (ExceptionVerifier.this.consumer != null) {
                        Assert.fail((String)"expected exception not thrown");
                    }
                }
                catch (RuntimeException e) {
                    if (ExceptionVerifier.this.consumer == null) {
                        throw e;
                    }
                    try {
                        ExceptionVerifier.this.consumer.accept(e);
                    }
                    catch (ClassCastException cce) {
                        throw e;
                    }
                }
                finally {
                    ExceptionVerifier.this.consumer = null;
                }
            }
        };
    }
}

