/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.junit.base.junit5;

import java.lang.annotation.Annotation;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;

public interface JUnit5InjectionSupport
extends ParameterResolver,
TestInstancePostProcessor {
    public Class<? extends Annotation> injectionMarker();

    default public boolean supports(Class<?> type) {
        return type.isInstance(this);
    }

    default public Object findInstance(ExtensionContext extensionContext, Class<?> type, Annotation marker) {
        return this.findInstance(extensionContext, type);
    }

    default public Object findInstance(ExtensionContext extensionContext, Class<?> type) {
        return this;
    }

    default public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.supports(parameterContext.getParameter().getType());
    }

    default public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.findInstance(extensionContext, parameterContext.getParameter().getType());
    }

    default public void postProcessTestInstance(Object testInstance, ExtensionContext context) {
        for (Class testClass = context.getRequiredTestClass(); testClass != Object.class; testClass = testClass.getSuperclass()) {
            Stream.of(testClass.getDeclaredFields()).filter(c -> c.isAnnotationPresent(this.injectionMarker())).forEach(f -> {
                if (!this.supports(f.getType())) {
                    throw new IllegalArgumentException("@" + this.injectionMarker() + " not supported on " + f);
                }
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                try {
                    f.set(testInstance, this.findInstance(context, f.getType(), f.getAnnotation(this.injectionMarker())));
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
    }
}

