/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.record;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.talend.sdk.component.api.record.Schema;

public class SchemaImpl
implements Schema {
    private Schema.Type type;
    private Schema elementSchema;
    private List<Schema.Entry> entries;

    public Schema.Type getType() {
        return this.type;
    }

    public Schema getElementSchema() {
        return this.elementSchema;
    }

    public List<Schema.Entry> getEntries() {
        return this.entries;
    }

    public void setType(Schema.Type type) {
        this.type = type;
    }

    public void setElementSchema(Schema elementSchema) {
        this.elementSchema = elementSchema;
    }

    public void setEntries(List<Schema.Entry> entries) {
        this.entries = entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaImpl)) {
            return false;
        }
        SchemaImpl other = (SchemaImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Schema.Type this$type = this.getType();
        Schema.Type other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Schema this$elementSchema = this.getElementSchema();
        Schema other$elementSchema = other.getElementSchema();
        if (this$elementSchema == null ? other$elementSchema != null : !this$elementSchema.equals(other$elementSchema)) {
            return false;
        }
        List<Schema.Entry> this$entries = this.getEntries();
        List<Schema.Entry> other$entries = other.getEntries();
        return !(this$entries == null ? other$entries != null : !((Object)this$entries).equals(other$entries));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Schema.Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Schema $elementSchema = this.getElementSchema();
        result = result * 59 + ($elementSchema == null ? 43 : $elementSchema.hashCode());
        List<Schema.Entry> $entries = this.getEntries();
        result = result * 59 + ($entries == null ? 43 : ((Object)$entries).hashCode());
        return result;
    }

    public String toString() {
        return "SchemaImpl(type=" + this.getType() + ", elementSchema=" + this.getElementSchema() + ", entries=" + this.getEntries() + ")";
    }

    public SchemaImpl() {
    }

    public SchemaImpl(Schema.Type type, Schema elementSchema, List<Schema.Entry> entries) {
        this.type = type;
        this.elementSchema = elementSchema;
        this.entries = entries;
    }

    public static class EntryImpl
    implements Schema.Entry {
        private String name;
        private Schema.Type type;
        private boolean nullable;
        private Object defaultValue;
        private Schema elementSchema;
        private String comment;

        public String getName() {
            return this.name;
        }

        public Schema.Type getType() {
            return this.type;
        }

        public boolean isNullable() {
            return this.nullable;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public Schema getElementSchema() {
            return this.elementSchema;
        }

        public String getComment() {
            return this.comment;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setType(Schema.Type type) {
            this.type = type;
        }

        public void setNullable(boolean nullable) {
            this.nullable = nullable;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public void setElementSchema(Schema elementSchema) {
            this.elementSchema = elementSchema;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EntryImpl)) {
                return false;
            }
            EntryImpl other = (EntryImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Schema.Type this$type = this.getType();
            Schema.Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            if (this.isNullable() != other.isNullable()) {
                return false;
            }
            Object this$defaultValue = this.getDefaultValue();
            Object other$defaultValue = other.getDefaultValue();
            if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
                return false;
            }
            Schema this$elementSchema = this.getElementSchema();
            Schema other$elementSchema = other.getElementSchema();
            if (this$elementSchema == null ? other$elementSchema != null : !this$elementSchema.equals(other$elementSchema)) {
                return false;
            }
            String this$comment = this.getComment();
            String other$comment = other.getComment();
            return !(this$comment == null ? other$comment != null : !this$comment.equals(other$comment));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EntryImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Schema.Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            result = result * 59 + (this.isNullable() ? 79 : 97);
            Object $defaultValue = this.getDefaultValue();
            result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
            Schema $elementSchema = this.getElementSchema();
            result = result * 59 + ($elementSchema == null ? 43 : $elementSchema.hashCode());
            String $comment = this.getComment();
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            return result;
        }

        public String toString() {
            return "SchemaImpl.EntryImpl(name=" + this.getName() + ", type=" + this.getType() + ", nullable=" + this.isNullable() + ", defaultValue=" + this.getDefaultValue() + ", elementSchema=" + this.getElementSchema() + ", comment=" + this.getComment() + ")";
        }

        public EntryImpl() {
        }

        public EntryImpl(String name, Schema.Type type, boolean nullable, Object defaultValue, Schema elementSchema, String comment) {
            this.name = name;
            this.type = type;
            this.nullable = nullable;
            this.defaultValue = defaultValue;
            this.elementSchema = elementSchema;
            this.comment = comment;
        }

        public static class BuilderImpl
        implements Schema.Entry.Builder {
            private String name;
            private Schema.Type type;
            private boolean nullable;
            private Object defaultValue;
            private Schema elementSchema;
            private String comment;

            private static String sanitizeConnectionName(String name) {
                char[] sanitized;
                if (name.isEmpty()) {
                    return name;
                }
                char[] original = name.toCharArray();
                boolean skipFirstChar = !Character.isLetter(original[0]) && original[0] != '_';
                int offset = skipFirstChar ? 1 : 0;
                char[] cArray = sanitized = skipFirstChar ? new char[original.length - offset] : new char[original.length];
                if (!skipFirstChar) {
                    sanitized[0] = original[0];
                }
                for (int i = 1; i < original.length; ++i) {
                    sanitized[i - offset] = !Character.isLetterOrDigit(original[i]) && original[i] != '_' ? 95 : original[i];
                }
                return new String(sanitized);
            }

            public Schema.Entry.Builder withName(String name) {
                this.name = BuilderImpl.sanitizeConnectionName(name);
                return this;
            }

            public Schema.Entry.Builder withType(Schema.Type type) {
                this.type = type;
                return this;
            }

            public Schema.Entry.Builder withNullable(boolean nullable) {
                this.nullable = nullable;
                return this;
            }

            public <T> Schema.Entry.Builder withDefaultValue(T value) {
                this.defaultValue = value;
                return this;
            }

            public Schema.Entry.Builder withElementSchema(Schema schema) {
                this.elementSchema = schema;
                return this;
            }

            public Schema.Entry.Builder withComment(String comment) {
                this.comment = comment;
                return this;
            }

            public Schema.Entry build() {
                return new EntryImpl(this.name, this.type, this.nullable, this.defaultValue, this.elementSchema, this.comment);
            }
        }
    }

    public static class BuilderImpl
    implements Schema.Builder {
        private Schema.Type type;
        private Schema elementSchema;
        private List<Schema.Entry> entries = new ArrayList<Schema.Entry>();

        public Schema.Builder withElementSchema(Schema schema) {
            if (this.type != Schema.Type.ARRAY && schema != null) {
                throw new IllegalArgumentException("elementSchema is only valid for ARRAY type of schema");
            }
            this.elementSchema = schema;
            return this;
        }

        public Schema.Builder withType(Schema.Type type) {
            this.type = type;
            return this;
        }

        public Schema.Builder withEntry(Schema.Entry entry) {
            if (this.type != Schema.Type.RECORD) {
                throw new IllegalArgumentException("entry is only valid for RECORD type of schema");
            }
            if (this.entries == null) {
                this.entries = new ArrayList<Schema.Entry>();
            }
            this.entries.add(entry);
            return this;
        }

        public Schema build() {
            return new SchemaImpl(this.type, this.elementSchema, this.entries == null ? null : Collections.unmodifiableList(this.entries));
        }
    }
}

