/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.runtime.jsonb;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import javax.json.bind.adapter.JsonbAdapter;

public class MultipleFormatDateAdapter
implements JsonbAdapter<Date, String> {
    private static final ZoneId UTC = ZoneId.of("UTC");

    public Date adaptFromJson(String obj) {
        try {
            return Date.from(LocalDateTime.parse(obj).toInstant(ZoneOffset.UTC));
        }
        catch (DateTimeParseException pe) {
            return new Date(ZonedDateTime.parse(obj).toInstant().toEpochMilli());
        }
    }

    public String adaptToJson(Date obj) {
        return LocalDateTime.ofInstant(obj.toInstant(), UTC).toString();
    }
}

