/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.persistence;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;
import org.talend.esb.sam.common.event.Event;
import org.talend.esb.sam.common.event.MessageInfo;
import org.talend.esb.sam.common.event.Originator;
import org.talend.esb.sam.common.event.persistence.EventRepository;
import org.talend.esb.sam.server.persistence.EventRowMapper;
import org.talend.esb.sam.server.persistence.dialects.DatabaseDialect;

public class EventRepositoryImpl
extends SimpleJdbcDaoSupport
implements EventRepository {
    private static final Logger LOG = Logger.getLogger(EventRepositoryImpl.class.getName());
    private DatabaseDialect dialect;

    public void setDialect(DatabaseDialect dialect) {
        this.dialect = dialect;
    }

    public void writeEvent(Event event) {
        Originator originator = event.getOriginator();
        MessageInfo messageInfo = event.getMessageInfo();
        long id = this.dialect.getIncrementer().nextLongValue();
        event.setPersistedId(Long.valueOf(id));
        this.getSimpleJdbcTemplate().update("insert into EVENTS (ID, EI_TIMESTAMP, EI_EVENT_TYPE, ORIG_PROCESS_ID, ORIG_IP, ORIG_HOSTNAME,  ORIG_CUSTOM_ID, ORIG_PRINCIPAL, MI_MESSAGE_ID, MI_FLOW_ID, MI_PORT_TYPE, MI_OPERATION_NAME, MI_TRANSPORT_TYPE, CONTENT_CUT, MESSAGE_CONTENT)  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", new Object[]{event.getPersistedId(), event.getTimestamp(), event.getEventType().toString(), originator.getProcessId(), originator.getIp(), originator.getHostname(), originator.getCustomId(), originator.getPrincipal(), messageInfo.getMessageId(), messageInfo.getFlowId(), messageInfo.getPortType(), messageInfo.getOperationName(), messageInfo.getTransportType(), event.isContentCut(), event.getContent()});
        this.writeCustomInfo(event);
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("event [message_id=" + messageInfo.getMessageId() + "] persist to Database successful." + " ID=" + id);
        }
    }

    public Event readEvent(long id) {
        EventRowMapper rowMapper = new EventRowMapper();
        Event event = (Event)this.getSimpleJdbcTemplate().queryForObject("select * from EVENTS where ID=" + id, (RowMapper)rowMapper, new Object[0]);
        event.getCustomInfo().clear();
        event.getCustomInfo().putAll(this.readCustomInfo(id));
        return event;
    }

    private void writeCustomInfo(Event event) {
        for (Map.Entry customInfo : event.getCustomInfo().entrySet()) {
            long cust_id = this.dialect.getIncrementer().nextLongValue();
            this.getSimpleJdbcTemplate().update("insert into EVENTS_CUSTOMINFO (ID, EVENT_ID, CUST_KEY, CUST_VALUE) values (?,?,?,?)", new Object[]{cust_id, event.getPersistedId(), customInfo.getKey(), customInfo.getValue()});
        }
    }

    private Map<String, String> readCustomInfo(long eventId) {
        List rows = this.getSimpleJdbcTemplate().queryForList("select * from EVENTS_CUSTOMINFO where EVENT_ID=" + eventId, new Object[0]);
        HashMap<String, String> customInfo = new HashMap<String, String>(rows.size());
        for (Map row : rows) {
            customInfo.put((String)row.get("CUST_KEY"), (String)row.get("CUST_VALUE"));
        }
        return customInfo;
    }
}

