/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.persistence;

import com.ibatis.common.jdbc.ScriptRunner;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;

public class DBInitializer
implements InitializingBean {
    private static final Logger LOG = Logger.getLogger(DBInitializer.class.getName());
    private DataSource dataSource;
    private String createSql;
    private String createSqlInd;
    private final Map<String, String[]> createScripts = new HashMap<String, String[]>(){
        {
            this.put("derbyDialect", new String[]{"create.sql", "create_ind.sql"});
            this.put("h2Dialect", new String[]{"create_h2.sql", "create_h2_ind.sql"});
            this.put("mysqlDialect", new String[]{"create_mysql.sql", "create_mysql_ind.sql"});
            this.put("oracleDialect", new String[]{"create_oracle.sql", "create_oracle_ind.sql"});
            this.put("DB2Dialect", new String[]{"create_db2.sql", "create_db2_ind.sql"});
            this.put("sqlServerDialect", new String[]{"create_sqlserver.sql", "create_sqlserver_ind.sql"});
            this.put("postgresqlDialect", new String[]{"create_postgres.sql", "create_postgres_ind.sql"});
        }
    };

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(String dialect) {
        String[] scripts = this.createScripts.get(dialect);
        this.createSql = scripts[0];
        this.createSqlInd = scripts[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws Exception {
        Connection conn = null;
        try {
            boolean createTables = true;
            try {
                conn = this.dataSource.getConnection();
                ResultSet rs = conn.getMetaData().getTables(conn.getCatalog(), null, "EVENTS_CUSTOMINFO", null);
                while (rs.next()) {
                    createTables = false;
                }
            }
            catch (SQLException e) {
                LOG.warning("The create tables parameter has not been set. Tables and indexes will not be created.");
                createTables = false;
            }
            if (createTables) {
                ScriptRunner sr = new ScriptRunner(conn, false, false);
                sr.setLogWriter(null);
                sr.setErrorLogWriter(null);
                sr.runScript((Reader)new InputStreamReader(this.getClass().getResourceAsStream("/" + this.createSql)));
                if (this.createSqlInd != null && !this.createSqlInd.equals("")) {
                    sr.runScript((Reader)new InputStreamReader(this.getClass().getResourceAsStream("/" + this.createSqlInd)));
                } else {
                    LOG.warning("The script to create indexes has not been set. Indexes will not be created.");
                }
            }
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.warning("Unable to close JDBC connection.");
                }
            }
        }
    }
}

