/*
 * Decompiled with CFR 0.152.
 */
package org.talend.esb.sam.server.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.talend.esb.sam.server.persistence.criterias.Criteria;
import org.talend.esb.sam.server.persistence.criterias.DateCriteria;
import org.talend.esb.sam.server.persistence.criterias.PatternCriteria;
import org.talend.esb.sam.server.persistence.dialects.QueryFilter;

public class CriteriaAdapter
implements SqlParameterSource,
QueryFilter {
    private static final Logger LOG = Logger.getLogger(CriteriaAdapter.class.getName());
    private static final String CONSUMER_EVENT_TYPES = "(EI_EVENT_TYPE = 'REQ_OUT' or EI_EVENT_TYPE = 'RESP_IN')";
    private static final String PROVIDER_EVENT_TYPES = "(EI_EVENT_TYPE = 'REQ_IN' or EI_EVENT_TYPE = 'RESP_OUT')";
    private static final Criteria[] FILTER_CRITERIAS = new Criteria[]{new PatternCriteria("transport", "MI_TRANSPORT_TYPE"), new PatternCriteria("port", "MI_PORT_TYPE"), new PatternCriteria("operation", "MI_OPERATION_NAME"), new DateCriteria("timestamp_before", "EI_TIMESTAMP"), new DateCriteria("timestamp_after", "EI_TIMESTAMP"), new DateCriteria("timestamp_on", "EI_TIMESTAMP"), new PatternCriteria("flowID", "MI_FLOW_ID"), new PatternCriteria("consumer_ip", "ORIG_IP", "(EI_EVENT_TYPE = 'REQ_OUT' or EI_EVENT_TYPE = 'RESP_IN')"), new PatternCriteria("consumer_host", "ORIG_HOSTNAME", "(EI_EVENT_TYPE = 'REQ_OUT' or EI_EVENT_TYPE = 'RESP_IN')"), new PatternCriteria("provider_ip", "ORIG_IP", "(EI_EVENT_TYPE = 'REQ_IN' or EI_EVENT_TYPE = 'RESP_OUT')"), new PatternCriteria("provider_host", "ORIG_HOSTNAME", "(EI_EVENT_TYPE = 'REQ_IN' or EI_EVENT_TYPE = 'RESP_OUT')")};
    private static final String LIMIT_NAME = "limit";
    private static final String OFFSET_NAME = "offset";
    private final Map<String, Criteria> criterias;
    private final long offset;
    private final long limit;

    public CriteriaAdapter(long offset, long limit, Map<String, String[]> params) {
        this.offset = offset;
        this.limit = limit;
        this.criterias = this.getCriterias(params);
    }

    private Map<String, Criteria> getCriterias(Map<String, String[]> params) {
        HashMap<String, Criteria> result = new HashMap<String, Criteria>();
        block2: for (Map.Entry<String, String[]> param : params.entrySet()) {
            for (Criteria criteria : FILTER_CRITERIAS) {
                if (!criteria.getName().equals(param.getKey())) continue;
                try {
                    Criteria[] parsedCriterias;
                    for (Criteria parsedCriteria : parsedCriterias = criteria.parseValue(param.getValue()[0])) {
                        result.put(parsedCriteria.getName(), parsedCriteria);
                    }
                    continue block2;
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error parsing parameter " + param.getKey(), e);
                    continue block2;
                }
            }
        }
        return result;
    }

    public boolean hasValue(String paramName) {
        return this.criterias.containsKey(paramName) || LIMIT_NAME.equals(paramName) || OFFSET_NAME.equals(paramName);
    }

    public Object getValue(String paramName) throws IllegalArgumentException {
        if (!this.hasValue(paramName)) {
            throw new IllegalArgumentException("Can't find criteria with name " + paramName);
        }
        if (LIMIT_NAME.equals(paramName)) {
            return this.limit;
        }
        if (OFFSET_NAME.equals(paramName)) {
            return this.offset;
        }
        return this.criterias.get(paramName).getValue();
    }

    public int getSqlType(String paramName) {
        if (!this.hasValue(paramName)) {
            return Integer.MIN_VALUE;
        }
        Object value = this.getValue(paramName);
        return StatementCreatorUtils.javaTypeToSqlParameterType(value.getClass());
    }

    public String getTypeName(String paramName) {
        return null;
    }

    @Override
    public String getWhereClause() {
        StringBuilder result = new StringBuilder();
        ArrayList<String> names = new ArrayList<String>(this.criterias.keySet());
        Collections.sort(names);
        for (String key : names) {
            Criteria criteria = this.criterias.get(key);
            if (result.length() > 0) {
                result.append(" AND ");
            }
            result.append('(').append((CharSequence)criteria.getFilterClause()).append(')');
        }
        return result.toString();
    }
}

