/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security.context;

import java.security.Principal;
import javax.security.auth.Subject;
import org.switchyard.Exchange;
import org.switchyard.ExchangeSecurity;
import org.switchyard.ServiceDomain;
import org.switchyard.ServiceSecurity;
import org.switchyard.security.SecurityMetadata;
import org.switchyard.security.context.SecurityContext;
import org.switchyard.security.context.SecurityContextManager;

public class DefaultExchangeSecurity
implements ExchangeSecurity {
    private final Exchange _exchange;
    private final String _securityDomain;
    private final SecurityContextManager _securityContextManager;

    public DefaultExchangeSecurity(Exchange exchange) {
        this._exchange = exchange;
        SecurityMetadata securityMetadata = SecurityMetadata.getSecurityMetadata(exchange);
        ServiceSecurity serviceSecurity = securityMetadata.getServiceSecurity();
        this._securityDomain = serviceSecurity != null ? serviceSecurity.getSecurityDomain() : null;
        ServiceDomain serviceDomain = securityMetadata.getServiceDomain();
        this._securityContextManager = serviceDomain != null ? new SecurityContextManager(serviceDomain) : null;
    }

    public SecurityContext getSecurityContext() {
        if (this._securityContextManager != null) {
            return this._securityContextManager.getContext(this._exchange);
        }
        return null;
    }

    public Subject getSubject() {
        if (this._securityContextManager != null) {
            return this._securityContextManager.getContext(this._exchange).getSubject(this._securityDomain);
        }
        return null;
    }

    public Principal getCallerPrincipal() {
        if (this._securityContextManager != null) {
            return this._securityContextManager.getContext(this._exchange).getCallerPrincipal(this._securityDomain);
        }
        return null;
    }

    public boolean isCallerInRole(String roleName) {
        if (this._securityContextManager != null) {
            return this._securityContextManager.getContext(this._exchange).isCallerInRole(roleName, this._securityDomain);
        }
        return false;
    }
}

