/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import org.switchyard.common.util.ProviderRegistry;
import org.switchyard.security.credential.extractor.DefaultServletRequestCredentialExtractor;
import org.switchyard.security.credential.extractor.ServletRequestCredentialExtractor;
import org.switchyard.security.provider.DefaultSecurityProvider;
import org.switchyard.security.provider.SecurityProvider;

public final class SecurityServices {
    private SecurityServices() {
    }

    public static final SecurityProvider getSecurityProvider() {
        SecurityProvider sp = SecurityServices.getProvider(SecurityProvider.class);
        return sp != null ? sp : new DefaultSecurityProvider();
    }

    public static final ServletRequestCredentialExtractor getServletRequestCredentialExtractor() {
        ServletRequestCredentialExtractor srce = SecurityServices.getProvider(ServletRequestCredentialExtractor.class);
        return srce != null ? srce : new DefaultServletRequestCredentialExtractor();
    }

    private static final <T> T getProvider(Class<T> clazz) {
        return (T)ProviderRegistry.getProvider(clazz, (ClassLoader)clazz.getClassLoader());
    }
}

