/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.runtime.util;

import javax.naming.InitialContext;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.switchyard.common.util.ProviderRegistry;

public final class TransactionManagerLocator {
    private static final String JBOSS_JNDI_TRANSACTION_MANAGER = "java:jboss/TransactionManager";
    private static final String OSGI_JNDI_TRANSACTION_MANAGER = "osgi:service/javax.transaction.TransactionManager";
    private static final Logger LOGGER = Logger.getLogger(TransactionManagerLocator.class);

    private TransactionManagerLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TransactionManager locateTransactionManager() {
        InitialContext ic;
        TransactionManager tm = (TransactionManager)ProviderRegistry.getProvider(TransactionManager.class);
        if (tm != null) {
            LOGGER.debug((Object)"Found a TransactionManager in ProviderRegistry");
            return tm;
        }
        try {
            ic = new InitialContext();
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Failed to create InitialContext - Transaction Policy handling will not be available.", (Throwable)e);
            return null;
        }
        try {
            tm = (TransactionManager)TransactionManagerLocator.lookupInJndi(ic, JBOSS_JNDI_TRANSACTION_MANAGER);
            if (tm != null) {
                LOGGER.debug((Object)"Found a TransactionManager in JNDI at 'java:jboss/TransactionManager'");
                TransactionManager e = tm;
                return e;
            }
            tm = (TransactionManager)TransactionManagerLocator.lookupInJndi(ic, OSGI_JNDI_TRANSACTION_MANAGER);
            if (tm != null) {
                LOGGER.debug((Object)"Found a TransactionManager in JNDI at 'osgi:service/javax.transaction.TransactionManager'");
                TransactionManager e = tm;
                return e;
            }
        }
        finally {
            try {
                ic.close();
            }
            catch (Exception e) {
                LOGGER.debug((Object)e);
            }
        }
        LOGGER.debug((Object)"No TransactionManager found at 'java:jboss/TransactionManager' nor 'osgi:service/javax.transaction.TransactionManager'");
        return null;
    }

    private static Object lookupInJndi(InitialContext ic, String name) {
        try {
            return ic.lookup(name);
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            return null;
        }
    }
}

