/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.soap.endpoint;

import java.net.MalformedURLException;
import javax.xml.ws.WebServiceFeature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.switchyard.ServiceDomain;
import org.switchyard.component.common.Endpoint;
import org.switchyard.component.soap.AddressingInterceptor;
import org.switchyard.component.soap.InboundHandler;
import org.switchyard.component.soap.config.model.SOAPBindingModel;
import org.switchyard.component.soap.endpoint.EndpointPublisher;
import org.switchyard.component.soap.util.WSDLUtil;

public abstract class AbstractEndpointPublisher
implements EndpointPublisher {
    private String _ctxRoot;
    private String _ctxPath;
    private String _wsdlLocation;

    public String getContextRoot() {
        return this._ctxRoot;
    }

    public String getContextPath() {
        return this._ctxPath;
    }

    public String getWsdlLocation() {
        return this._wsdlLocation;
    }

    protected void initialize(SOAPBindingModel config) throws MalformedURLException {
        if (config.getContextPath() != null) {
            this._ctxRoot = config.getContextPath();
            this._ctxPath = this._ctxRoot + "/" + config.getPort().getServiceName();
        } else {
            this._ctxRoot = "";
            this._ctxPath = config.getPort().getServiceName();
        }
        this._wsdlLocation = WSDLUtil.getURL(config.getWsdl()).toExternalForm();
    }

    @Override
    public synchronized Endpoint publish(ServiceDomain domain, SOAPBindingModel config, String bindingId, InboundHandler handler) {
        return this.publish(domain, config, bindingId, handler, new WebServiceFeature[]{null});
    }

    @Override
    public Interceptor<? extends Message> createAddressingInterceptor() {
        return new AddressingInterceptor();
    }
}

