/*
 * Decompiled with CFR 0.152.
 */
package subscript.vm;

import scala.Function0;
import scala.Serializable;
import subscript.vm.CodeExecutorTrait;
import subscript.vm.EventHandlingCodeFragmentExecutor;
import subscript.vm.N_code_eventhandling;
import subscript.vm.N_code_normal;
import subscript.vm.N_code_threaded;
import subscript.vm.N_code_unsure;
import subscript.vm.NormalCodeFragmentExecutor;
import subscript.vm.ThreadedCodeFragmentExecutor;
import subscript.vm.TinyCodeExecutor;
import subscript.vm.UnsureCodeFragmentExecutor;
import subscript.vm.executor.ScriptExecutor;
import subscript.vm.model.callgraph.CallGraphNode;
import subscript.vm.model.template.TemplateCodeHolder;

public final class CodeExecutor$ {
    public static final CodeExecutor$ MODULE$;

    static {
        new CodeExecutor$();
    }

    public CodeExecutorTrait defaultCodeFragmentExecutorFor(CallGraphNode node, ScriptExecutor<?> scriptExecutor) {
        CodeExecutorTrait codeExecutorTrait;
        CallGraphNode callGraphNode = node;
        if (callGraphNode instanceof N_code_normal) {
            N_code_normal n_code_normal = (N_code_normal)callGraphNode;
            codeExecutorTrait = new NormalCodeFragmentExecutor(n_code_normal, scriptExecutor);
        } else if (callGraphNode instanceof N_code_unsure) {
            N_code_unsure n_code_unsure = (N_code_unsure)callGraphNode;
            codeExecutorTrait = new UnsureCodeFragmentExecutor(n_code_unsure, scriptExecutor);
        } else if (callGraphNode instanceof N_code_threaded) {
            N_code_threaded n_code_threaded = (N_code_threaded)callGraphNode;
            codeExecutorTrait = new ThreadedCodeFragmentExecutor(n_code_threaded, scriptExecutor);
        } else if (callGraphNode instanceof N_code_eventhandling) {
            N_code_eventhandling n_code_eventhandling = (N_code_eventhandling)callGraphNode;
            codeExecutorTrait = new EventHandlingCodeFragmentExecutor(n_code_eventhandling, scriptExecutor);
        } else {
            codeExecutorTrait = new TinyCodeExecutor(node, scriptExecutor);
        }
        return codeExecutorTrait;
    }

    public <N extends CallGraphNode, R> R executeCodeDirectly(N n) {
        return (R)((TemplateCodeHolder)n.template()).code().apply(n);
    }

    public <N extends CallGraphNode, R> R executeCode(N n) {
        TemplateCodeHolder template = (TemplateCodeHolder)n.template();
        return this.executeCode(n, (Function0<R>)new Serializable(n, template){
            public static final long serialVersionUID = 0L;
            private final CallGraphNode n$1;
            private final TemplateCodeHolder template$1;

            public final R apply() {
                return (R)this.template$1.code().apply((Object)this.n$1);
            }
            {
                this.n$1 = n$1;
                this.template$1 = template$1;
            }
        });
    }

    public <N extends CallGraphNode, R> R executeCodeIfDefined(N n, Function0<R> code) {
        return code == null ? null : (R)this.executeCode(n, code);
    }

    public <N extends CallGraphNode, R> R executeCode(N n, Function0<R> c) {
        return n.codeExecutor().doCodeExecution(c);
    }

    private CodeExecutor$() {
        MODULE$ = this;
    }
}

