/*
 * Decompiled with CFR 0.152.
 */
package subscript.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.lang.reflect.Method;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import scala.Console$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.swing.Alignment$;
import scala.swing.BorderPanel;
import scala.swing.BoxPanel;
import scala.swing.Button;
import scala.swing.CheckBox;
import scala.swing.Component;
import scala.swing.Dialog;
import scala.swing.Dialog$;
import scala.swing.FlowPanel;
import scala.swing.Frame;
import scala.swing.Frame$;
import scala.swing.Label;
import scala.swing.ListView;
import scala.swing.Panel;
import scala.swing.ScrollPane;
import scala.swing.Slider;
import scala.swing.SplitPane;
import scala.swing.TextField;
import subscript.swing.GraphicalDebugger;
import subscript.swing.GraphicalDebugger$;
import subscript.swing.GraphicalDebugger$MessageStatusLock$;
import subscript.vm.AAHappened;
import subscript.vm.AAToBeExecuted;
import subscript.vm.Activation;
import subscript.vm.Break;
import subscript.vm.CallGraphMessage;
import subscript.vm.Continuation;
import subscript.vm.Deactivation;
import subscript.vm.Exclude;
import subscript.vm.MsgListener;
import subscript.vm.MsgPublisher;
import subscript.vm.N_call;
import subscript.vm.N_launch_anchor;
import subscript.vm.N_n_ary_op;
import subscript.vm.Script;
import subscript.vm.ScriptNode;
import subscript.vm.SimpleScriptDebuggerClass;
import subscript.vm.SuccessMsg;
import subscript.vm.executor.ScriptExecutor;
import subscript.vm.executor.ScriptExecutorFactory$;
import subscript.vm.executor.data.MessageQueue;
import subscript.vm.model.callgraph.ActivationMode$;
import subscript.vm.model.callgraph.CallGraphNode;
import subscript.vm.model.template.ChildNode;
import subscript.vm.model.template.TemplateNode;
import subscript.vm.model.template.concrete.T_call;
import subscript.vm.model.template.concrete.T_script;

public abstract class GraphicalDebugger$class {
    public static int traceLevel(GraphicalDebugger $this) {
        return 2;
    }

    public static int otherTraceLevel(GraphicalDebugger $this) {
        return 1;
    }

    public static void trace(GraphicalDebugger $this, Function0 s) {
        if ($this.traceLevel() > 0) {
            Predef$.MODULE$.println(s.apply());
            Console$.MODULE$.flush();
        }
    }

    public static ScriptExecutor otherScriptExecutor(GraphicalDebugger $this) {
        return $this.subscript$swing$GraphicalDebugger$$_otherScriptExecutor();
    }

    public static void attach(GraphicalDebugger $this, MsgPublisher p) {
        $this.subscript$swing$GraphicalDebugger$$super$attach(p);
        $this.subscript$swing$GraphicalDebugger$$_otherScriptExecutor_$eq((ScriptExecutor)p);
        $this.subscript$swing$GraphicalDebugger$$_otherScriptExecutor().traceLevel_$eq($this.otherTraceLevel());
        $this.subscript$swing$GraphicalDebugger$$_otherScriptExecutor().name_$eq("otherScriptExecutor");
    }

    public static void main(GraphicalDebugger $this, String[] args) {
        String[] lArgs = args;
        if (Predef$.MODULE$.refArrayOps((Object[])lArgs).isEmpty()) {
            return;
        }
        ScriptExecutorFactory$.MODULE$.addScriptDebugger((MsgListener)$this);
        $this.top().visible_$eq(true);
        String string = (String)Predef$.MODULE$.refArrayOps((Object[])lArgs).head();
        if ("-s".equals(string)) {
            if (Predef$.MODULE$.refArrayOps((Object[])(lArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])lArgs).tail())).isEmpty()) {
                return;
            }
            $this.descriptionTF().text_$eq((String)Predef$.MODULE$.refArrayOps((Object[])lArgs).head());
            lArgs = (String[])Predef$.MODULE$.refArrayOps((Object[])lArgs).tail();
            if (Predef$.MODULE$.refArrayOps((Object[])lArgs).isEmpty()) {
                return;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        $this.vmThread_$eq(new Thread($this){
            private final /* synthetic */ GraphicalDebugger $outer;

            public void run() {
                this.$outer.live();
                this.$outer.quit();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        $this.vmThread().start();
        String className = (String)Predef$.MODULE$.refArrayOps((Object[])lArgs).head();
        try {
            Class<?> c = Class.forName(className);
            Method m = c.getMethod("main", String[].class);
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"debugger: ").append((Object)$this.getClass().getCanonicalName()).append((Object)" on: ").append((Object)className).toString());
            m.invoke(null, Predef$.MODULE$.refArrayOps((Object[])lArgs).tail());
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println((Object)throwable);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Could not find class ").append((Object)className).toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List interestingContinuationInternals(GraphicalDebugger $this, Continuation c) {
        void var2_2;
        Nil$ ss = Nil$.MODULE$;
        if (c != null) {
            if (c.success() != null) {
                ss = ss.$colon$colon((Object)"Success");
            }
            if (!c.aaHappeneds().isEmpty()) {
                ss = ss.$colon$colon((Object)"AA Happened");
            }
            if (!c.deactivations().isEmpty()) {
                ss = ss.$colon$colon((Object)"Deactivations");
            }
            if (c.activation() != null) {
                ss = ss.$colon$colon((Object)"Activation");
            }
        }
        return var2_2;
    }

    public static Color fillColor(GraphicalDebugger $this, CallGraphNode n, Color defaultColor, boolean allowOverride) {
        return allowOverride && n.isExecuting() ? $this.lightPurple() : (allowOverride && n.isActionBusy() ? $this.lightRed() : defaultColor);
    }

    public static void drawStringCentered(GraphicalDebugger $this, Graphics2D g, String s, int cx, int cy) {
        int sw = g.getFontMetrics().stringWidth(s);
        int sh = g.getFontMetrics().getHeight();
        g.drawString(s, cx - sw / 2, cy + sh / 2);
    }

    public static void drawStringTopLeft(GraphicalDebugger $this, Graphics2D g, String s, int x, int y) {
        int sh = g.getFontMetrics().getHeight();
        g.drawString(s, x, y + sh / 2);
    }

    public static void drawStringTopRight(GraphicalDebugger $this, Graphics2D g, String s, int x, int y) {
        int sw = g.getFontMetrics().stringWidth(s);
        int sh = g.getFontMetrics().getHeight();
        g.drawString(s, x - sw, y + sh / 2);
    }

    public static void emphasize_g(GraphicalDebugger $this, Graphics2D g, boolean doIt) {
        if (doIt) {
            g.setColor(Color.red);
            g.setStroke($this.fatStroke());
        } else {
            g.setColor(Color.black);
            g.setStroke($this.normalStroke());
        }
    }

    public static void onPaintTemplateTrees(GraphicalDebugger $this, Graphics2D g) {
        int GRID_W = 50;
        int GRID_H = 33;
        double RATIO_W = 0.8;
        double RATIO_H = 0.67;
        int BOX_W = (int)((double)GRID_W * RATIO_W);
        int BOX_H = (int)((double)GRID_H * RATIO_H);
        int hOffset = (GRID_W - BOX_W) / 2;
        int vOffset = (GRID_H - BOX_H) / 2;
        if ($this.otherScriptExecutor() == null) {
            return;
        }
        g.setFont($this.normalFont());
        DoubleRef currentXGrid = DoubleRef.create((double)0.0);
        GraphicalDebugger$class.getScriptTemplates$1($this).foreach((Function1)new Serializable($this, GRID_W, GRID_H, BOX_W, BOX_H, hOffset, vOffset, currentXGrid, g){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphicalDebugger $outer;
            private final int GRID_W$1;
            private final int GRID_H$1;
            private final int BOX_W$1;
            private final int BOX_H$1;
            private final int hOffset$1;
            private final int vOffset$1;
            private final DoubleRef currentXGrid$1;
            private final Graphics2D g$1;

            public final void apply(T_script t) {
                this.currentXGrid$1.elem += GraphicalDebugger$class.drawTemplateTree$1(this.$outer, (TemplateNode)t, this.currentXGrid$1.elem, 0, this.GRID_W$1, this.GRID_H$1, this.BOX_W$1, this.BOX_H$1, this.hOffset$1, this.vOffset$1, this.g$1)._1$mcD$sp();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.GRID_W$1 = GRID_W$1;
                this.GRID_H$1 = GRID_H$1;
                this.BOX_W$1 = BOX_W$1;
                this.BOX_H$1 = BOX_H$1;
                this.hOffset$1 = hOffset$1;
                this.vOffset$1 = vOffset$1;
                this.currentXGrid$1 = currentXGrid$1;
                this.g$1 = g$1;
            }
        });
    }

    public static void onPaintCallGraph(GraphicalDebugger $this, Graphics2D g) {
        int GRID_W = 90;
        int GRID_H = 43;
        double RATIO_W = 0.75;
        double RATIO_H = 0.6;
        int BOX_W = (int)((double)GRID_W * RATIO_W);
        int BOX_H = (int)((double)GRID_H * RATIO_H);
        int hOffset = (GRID_W - BOX_W) / 2;
        int vOffset = (GRID_H - BOX_H) / 2;
        g.setFont($this.normalFont());
        if ($this.otherScriptExecutor() != null) {
            GraphicalDebugger$class.drawTree$1($this, (CallGraphNode)$this.rootNode(), 0.0, 0, GRID_W, GRID_H, BOX_W, BOX_H, hOffset, vOffset, g);
        }
    }

    public static void sleep(GraphicalDebugger $this, long duration_ms) {
        try {
            Thread.sleep(duration_ms);
        }
        catch (InterruptedException interruptedException) {
            Predef$.MODULE$.println((Object)"sleep interrupted");
        }
    }

    public static boolean confirmExit(GraphicalDebugger $this) {
        Enumeration.Value value = Dialog$.MODULE$.showConfirmation((Component)$this.exitButton(), (Object)"Are you sure?", "About to exit", Dialog$.MODULE$.showConfirmation$default$4(), Dialog$.MODULE$.showConfirmation$default$5(), Dialog$.MODULE$.showConfirmation$default$6());
        Enumeration.Value value2 = Dialog.Result$.MODULE$.Yes();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static boolean shouldStep(GraphicalDebugger $this) {
        boolean bl;
        CallGraphMessage callGraphMessage = $this.currentMessage();
        if (callGraphMessage instanceof Activation) {
            bl = $this.checkBox_step_Activation().selected();
        } else if (callGraphMessage instanceof Deactivation) {
            bl = $this.checkBox_step_Deactivation().selected();
        } else if (callGraphMessage instanceof AAToBeExecuted) {
            bl = $this.checkBox_step_AAToBeExecuted().selected();
        } else if (callGraphMessage instanceof AAHappened) {
            bl = $this.checkBox_step_AAHappened().selected();
        } else if (callGraphMessage instanceof SuccessMsg) {
            bl = $this.checkBox_step_Success().selected();
        } else if (callGraphMessage instanceof Break) {
            bl = $this.checkBox_step_Break().selected();
        } else if (callGraphMessage instanceof Exclude) {
            bl = $this.checkBox_step_Exclude().selected();
        } else if (callGraphMessage instanceof Continuation) {
            Continuation continuation = (Continuation)callGraphMessage;
            bl = $this.checkBox_step_Continuation().selected() && !$this.interestingContinuationInternals(continuation).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public static int MAX_STEP_DELAY_SEC(GraphicalDebugger $this) {
        return 5;
    }

    public static int stepSleep_ms(GraphicalDebugger $this) {
        return Predef$.MODULE$.double2Double(package$.MODULE$.pow((double)($this.speedSlider().max() - $this.speedSlider().value()) / (double)$this.speedSlider().max(), 3.0) * (double)$this.MAX_STEP_DELAY_SEC() * (double)1000).intValue();
    }

    public static void waitForStepTimeout(GraphicalDebugger $this) {
        try {
            int sleepPart_ms = 10;
            for (int slept_ms = 0; slept_ms < $this.stepSleep_ms(); slept_ms += sleepPart_ms) {
                Thread.sleep(sleepPart_ms);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void logMessage_GUIThread(GraphicalDebugger $this, String m, CallGraphMessage msg) {
        CallGraphMessage callGraphMessage = msg;
        boolean bl = callGraphMessage instanceof Activation ? $this.checkBox_log_Activation().selected() : (callGraphMessage instanceof Deactivation ? $this.checkBox_log_Deactivation().selected() : (callGraphMessage instanceof AAToBeExecuted ? $this.checkBox_log_AAToBeExecuted().selected() : (callGraphMessage instanceof AAHappened ? $this.checkBox_log_AAHappened().selected() : (callGraphMessage instanceof SuccessMsg ? $this.checkBox_log_Success().selected() : (callGraphMessage instanceof Break ? $this.checkBox_log_Break().selected() : (callGraphMessage instanceof Exclude ? $this.checkBox_log_Exclude().selected() : (callGraphMessage instanceof Continuation ? $this.checkBox_log_Continuation().selected() : false)))))));
        if (bl) {
            Runnable runnable = new Runnable($this, m, msg){
                private final /* synthetic */ GraphicalDebugger $outer;
                private final String m$1;
                private final CallGraphMessage msg$1;

                public void run() {
                    this.$outer.logMessage(this.m$1, this.msg$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                    this.msg$1 = msg$1;
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void logMessage(GraphicalDebugger $this, String m, CallGraphMessage msg) {
        if ($this.msgLogListModel().size() > $this.maxLogListMsgs()) {
            $this.msgLogListModel().removeRange(0, $this.logListMsgsCleanups());
        }
        $this.msgLogListModel().addElement(new StringBuilder().append((Object)m).append((Object)" ").append((Object)msg).toString());
        $this.msgLogListViewScrollPane().verticalScrollBar().value_$eq($this.msgLogListViewScrollPane().verticalScrollBar().maximum());
        $this.msgQueueListModel().clear();
        Ordering ord = ((MessageQueue)$this.otherScriptExecutor().msgQueue()).ordering();
        List orderedMessages = ((List)$this.callGraphMessages().toList().sorted(ord)).reverse();
        orderedMessages.foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphicalDebugger $outer;

            public final void apply(CallGraphMessage x$5) {
                this.$outer.msgQueueListModel().addElement(x$5);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void updateDisplay(GraphicalDebugger $this) {
        String s;
        String string = s = $this.currentMessage() == null ? "." : $this.currentMessage().toString();
        if (s.length() > 50) {
            s = new StringBuilder().append((Object)s.substring(0, 50)).append((Object)"...").toString();
        }
        $this.currentMessageTF().text_$eq(s);
        $this.logMessage(">>", $this.currentMessage());
        $this.callGraphPanel().repaint();
        $this.templateTreesPanel().repaint();
    }

    public static boolean doesThisAllowToBeDebugged(GraphicalDebugger $this) {
        return false;
    }

    public static void kickExecutors(GraphicalDebugger $this) {
        $this.kickExecutor((ScriptExecutor<?>)$this.myScriptExecutor());
        $this.kickExecutor($this.otherScriptExecutor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void kickExecutor(GraphicalDebugger $this, ScriptExecutor executor) {
        if (executor == null) return;
        ScriptExecutor scriptExecutor = executor;
        synchronized (scriptExecutor) {
            executor.notify();
            return;
        }
    }

    public static void messageBeingHandled(GraphicalDebugger $this, boolean value) {
        GraphicalDebugger$MessageStatusLock$ graphicalDebugger$MessageStatusLock$ = $this.MessageStatusLock();
        synchronized (graphicalDebugger$MessageStatusLock$) {
            $this.kickExecutor($this.otherScriptExecutor());
            $this.messageBeingHandled_$eq(value);
            $this.MessageStatusLock().notifyAll();
            return;
        }
    }

    public static void awaitMessageBeingHandled(GraphicalDebugger $this, boolean value) {
        GraphicalDebugger$MessageStatusLock$ graphicalDebugger$MessageStatusLock$ = $this.MessageStatusLock();
        synchronized (graphicalDebugger$MessageStatusLock$) {
            while ($this.messageBeingHandled() != value) {
                $this.MessageStatusLock().wait();
            }
            return;
        }
    }

    public static void dumpStacks(GraphicalDebugger $this) {
        JavaConversions$.MODULE$.mapAsScalaMap(Thread.getAllStackTraces()).withFilter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Thread, StackTraceElement[]> check$ifrefutable$1) {
                Tuple2<Thread, StackTraceElement[]> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphicalDebugger $outer;

            public final void apply(Tuple2<Thread, StackTraceElement[]> x$7) {
                Tuple2<Thread, StackTraceElement[]> tuple2 = x$7;
                if (tuple2 != null) {
                    Thread thread = (Thread)tuple2._1();
                    StackTraceElement[] sts = (StackTraceElement[])tuple2._2();
                    this.$outer.trace((Function0<Object>)new Serializable(this, thread){
                        public static final long serialVersionUID = 0L;
                        private final Thread thread$1;

                        public final Thread apply() {
                            return this.thread$1;
                        }
                        {
                            this.thread$1 = thread$1;
                        }
                    });
                    Predef$.MODULE$.refArrayOps((Object[])sts).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ GraphicalDebugger$.anonfun.dumpStacks.2 $outer;

                        public final void apply(StackTraceElement x$6) {
                            this.$outer.subscript$swing$GraphicalDebugger$$anonfun$$$outer().trace((Function0<Object>)new Serializable(this, x$6){
                                public static final long serialVersionUID = 0L;
                                private final StackTraceElement x$6$1;

                                public final StackTraceElement apply() {
                                    return this.x$6$1;
                                }
                                {
                                    this.x$6$1 = x$6$1;
                                }
                            });
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.trace((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ GraphicalDebugger subscript$swing$GraphicalDebugger$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static void dumpExecutors(GraphicalDebugger $this) {
        $this.dumpExecutor((ScriptExecutor<?>)$this.myScriptExecutor());
        $this.dumpExecutor($this.otherScriptExecutor());
    }

    public static void dumpExecutor(GraphicalDebugger $this, ScriptExecutor executor) {
        if ($this.traceLevel() > 1) {
            $this.trace((Function0<Object>)new Serializable($this, executor){
                public static final long serialVersionUID = 0L;
                private final ScriptExecutor executor$1;

                public final ScriptExecutor<Object> apply() {
                    return this.executor$1;
                }
                {
                    this.executor$1 = executor$1;
                }
            });
            $this.trace((Function0<Object>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "====================";
                }
            });
            SimpleScriptDebuggerClass debugger = new SimpleScriptDebuggerClass();
            debugger.attach((MsgPublisher)executor);
            debugger.traceLevel_$eq(4);
            debugger.traceTree();
            debugger.traceMessages();
            $this.trace((Function0<Object>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "";
                }
            });
        }
    }

    public static PriorityQueue callGraphMessages(GraphicalDebugger $this) {
        return ((MessageQueue)$this.otherScriptExecutor().msgQueue()).collection();
    }

    public static N_launch_anchor rootNode(GraphicalDebugger $this) {
        return $this.otherScriptExecutor().rootNode();
    }

    public static void messageHandled(GraphicalDebugger $this, CallGraphMessage m) {
        $this.currentMessage_$eq(m);
        $this.messageBeingHandled(true);
        $this.awaitMessageBeingHandled(false);
        $this.currentMessage_$eq(null);
    }

    public static void messageQueued(GraphicalDebugger $this, CallGraphMessage m) {
        $this.logMessage_GUIThread("++", m);
    }

    public static void messageDequeued(GraphicalDebugger $this, CallGraphMessage m) {
        $this.logMessage_GUIThread("--", m);
    }

    public static void messageContinuation(GraphicalDebugger $this, CallGraphMessage m, Continuation c) {
        $this.logMessage_GUIThread("**", (CallGraphMessage)c);
    }

    public static void messageAwaiting(GraphicalDebugger $this) {
        $this.trace((Function0<Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "messageAwaiting";
            }
        });
        if ($this.checkBox_log_Wait().selected()) {
            $this.currentMessageTF().text_$eq("Waiting...");
        }
        if ($this.checkBox_step_Wait().selected()) {
            $this.callGraphPanel().repaint();
        }
    }

    private static final void emphasize$1(GraphicalDebugger $this, boolean doIt, Graphics2D g$1) {
        $this.emphasize_g(g$1, doIt);
    }

    public static final void getScriptTemplates$2(GraphicalDebugger $this, CallGraphNode n, ListBuffer lb$1) {
        ScriptNode scriptNode;
        CallGraphNode callGraphNode = n;
        Object object = callGraphNode instanceof ScriptNode ? (lb$1.exists((Function1)new Serializable($this, scriptNode = (ScriptNode)callGraphNode){
            public static final long serialVersionUID = 0L;
            private final ScriptNode x2$1;

            public final boolean apply(T_script x$1) {
                String string = x$1.name().name();
                String string2 = this.x2$1.template().name().name();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.x2$1 = x2$1;
            }
        }) ? BoxedUnit.UNIT : lb$1.$plus$eq((Object)scriptNode.template())) : BoxedUnit.UNIT;
        CallGraphNode callGraphNode2 = n;
        if (callGraphNode2 != null) {
            CallGraphNode callGraphNode3 = callGraphNode2;
            callGraphNode3.forEachChild((Function1)new Serializable($this, lb$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GraphicalDebugger $outer;
                private final ListBuffer lb$1;

                public final void apply(CallGraphNode x$2) {
                    GraphicalDebugger$class.getScriptTemplates$2(this.$outer, x$2, this.lb$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.lb$1 = lb$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private static final List getScriptTemplates$1(GraphicalDebugger $this) {
        ListBuffer lb = new ListBuffer();
        GraphicalDebugger$class.getScriptTemplates$2($this, (CallGraphNode)$this.rootNode(), lb);
        return lb.toList();
    }

    public static final void drawEdge$1(GraphicalDebugger $this, TemplateNode p, double pwx, int pwy, TemplateNode c, double cwx, int cwy, int GRID_W$1, int GRID_H$1, int BOX_W$1, int BOX_H$1, int hOffset$1, int vOffset$1, Graphics2D g$1) {
        int pHCenter = (int)(pwx * (double)GRID_W$1) + BOX_W$1 / 2 + hOffset$1;
        int pBottom = pwy * GRID_H$1 + BOX_H$1 + vOffset$1;
        int cHCenter = (int)(cwx * (double)GRID_W$1) + BOX_W$1 / 2 + hOffset$1;
        int cTop = cwy * GRID_H$1 + vOffset$1;
        int x1 = pHCenter;
        int y1 = pBottom;
        int x2 = cHCenter;
        int y2 = cTop;
        g$1.drawLine(x1, y1, x2, y2);
    }

    public static final Tuple2 drawTemplateTree$1(GraphicalDebugger $this, TemplateNode t, double xGrid, int yGrid, int GRID_W$1, int GRID_H$1, int BOX_W$1, int BOX_H$1, int hOffset$1, int vOffset$1, Graphics2D g$1) {
        CallGraphNode n1;
        DoubleRef resultW = DoubleRef.create((double)0.0);
        ObjectRef childHCs = ObjectRef.create((Object)new ListBuffer());
        if (t.children().isEmpty()) {
            resultW.elem = 1.0;
        } else {
            t.children().foreach((Function1)new Serializable($this, GRID_W$1, GRID_H$1, BOX_W$1, BOX_H$1, hOffset$1, vOffset$1, xGrid, yGrid, resultW, childHCs, g$1){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GraphicalDebugger $outer;
                private final int GRID_W$1;
                private final int GRID_H$1;
                private final int BOX_W$1;
                private final int BOX_H$1;
                private final int hOffset$1;
                private final int vOffset$1;
                private final double xGrid$1;
                private final int yGrid$1;
                private final DoubleRef resultW$1;
                private final ObjectRef childHCs$1;
                private final Graphics2D g$1;

                public final ListBuffer<Object> apply(ChildNode ct) {
                    Tuple2 tuple2 = GraphicalDebugger$class.drawTemplateTree$1(this.$outer, (TemplateNode)ct, this.xGrid$1 + this.resultW$1.elem, this.yGrid$1 + 1, this.GRID_W$1, this.GRID_H$1, this.BOX_W$1, this.BOX_H$1, this.hOffset$1, this.vOffset$1, this.g$1);
                    if (tuple2 != null) {
                        Tuple2.mcDD.sp sp2;
                        double childW = tuple2._1$mcD$sp();
                        double childHC = tuple2._2$mcD$sp();
                        Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(childW, childHC);
                        double childW2 = sp3._1$mcD$sp();
                        double childHC2 = sp3._2$mcD$sp();
                        this.resultW$1.elem += childW2;
                        return ((ListBuffer)this.childHCs$1.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)childHC2));
                    }
                    throw new MatchError((Object)tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.GRID_W$1 = GRID_W$1;
                    this.GRID_H$1 = GRID_H$1;
                    this.BOX_W$1 = BOX_W$1;
                    this.BOX_H$1 = BOX_H$1;
                    this.hOffset$1 = hOffset$1;
                    this.vOffset$1 = vOffset$1;
                    this.xGrid$1 = xGrid$1;
                    this.yGrid$1 = yGrid$1;
                    this.resultW$1 = resultW$1;
                    this.childHCs$1 = childHCs$1;
                    this.g$1 = g$1;
                }
            });
        }
        double thisX = xGrid + (resultW.elem - 1.0) / (double)2;
        String s = t.toString();
        int sw = g$1.getFontMetrics().stringWidth(s);
        int boxWidth = package$.MODULE$.max(sw + 4, BOX_W$1);
        int hOffset1 = (GRID_W$1 - boxWidth) / 2;
        int boxLeft = (int)(thisX * (double)GRID_W$1) + hOffset1;
        int boxTop = yGrid * GRID_H$1 + vOffset$1;
        int hCenter = boxLeft + boxWidth / 2;
        int vCenter = boxTop + BOX_H$1 / 2;
        Rectangle r = new Rectangle(boxLeft, boxTop, boxWidth, BOX_H$1);
        CallGraphNode n = n1 = $this.currentMessage() == null ? null : $this.currentMessage().node();
        TemplateNode templateNode = t;
        boolean bl = templateNode instanceof T_call ? true : templateNode instanceof T_script;
        Font font = bl ? $this.smallFont() : $this.normalFont();
        Font nameFont = font;
        boolean isCurrentTemplate = $this.currentMessage() != null && n != null && n.template() != null && n.template() == t;
        g$1.setColor($this.fillColor(n, $this.lightOrange(), isCurrentTemplate));
        g$1.fill(r);
        GraphicalDebugger$class.emphasize$1($this, isCurrentTemplate, g$1);
        g$1.draw(r);
        GraphicalDebugger$class.emphasize$1($this, false, g$1);
        g$1.setFont(nameFont);
        $this.drawStringCentered(g$1, s, hCenter, vCenter - 3);
        ((IterableLike)t.children().zip((GenIterable)((ListBuffer)childHCs.elem), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this, GRID_W$1, GRID_H$1, BOX_W$1, BOX_H$1, hOffset$1, vOffset$1, t, yGrid, thisX, g$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GraphicalDebugger $outer;
            private final int GRID_W$1;
            private final int GRID_H$1;
            private final int BOX_W$1;
            private final int BOX_H$1;
            private final int hOffset$1;
            private final int vOffset$1;
            private final TemplateNode t$1;
            private final int yGrid$1;
            private final double thisX$1;
            private final Graphics2D g$1;

            public final void apply(Tuple2<TemplateNode, Object> c_hc) {
                GraphicalDebugger$class.drawEdge$1(this.$outer, this.t$1, this.thisX$1, this.yGrid$1, (TemplateNode)c_hc._1(), c_hc._2$mcD$sp(), this.yGrid$1 + 1, this.GRID_W$1, this.GRID_H$1, this.BOX_W$1, this.BOX_H$1, this.hOffset$1, this.vOffset$1, this.g$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.GRID_W$1 = GRID_W$1;
                this.GRID_H$1 = GRID_H$1;
                this.BOX_W$1 = BOX_W$1;
                this.BOX_H$1 = BOX_H$1;
                this.hOffset$1 = hOffset$1;
                this.vOffset$1 = vOffset$1;
                this.t$1 = t$1;
                this.yGrid$1 = yGrid$1;
                this.thisX$1 = thisX$1;
                this.g$1 = g$1;
            }
        });
        return new Tuple2.mcDD.sp(resultW.elem, thisX);
    }

    private static final void emphasize$2(GraphicalDebugger $this, boolean doIt, Graphics2D g$2) {
        $this.emphasize_g(g$2, doIt);
    }

    private static final void drawArrow$1(GraphicalDebugger $this, int x1, int y1, int x2, int y2, String s, Graphics2D g$2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        double angle = package$.MODULE$.atan2((double)dy, (double)dx);
        int len = Predef$.MODULE$.double2Double(package$.MODULE$.sqrt((double)(dx * dx + dy * dy))).intValue();
        int ARROW_HEAD_W = 5;
        int ARROW_HEAD_L = 15;
        GraphicalDebugger$class.emphasize$2($this, s != null, g$2);
        if (s != null) {
            g$2.setFont($this.normalFont());
            $this.drawStringTopLeft(g$2, s, x1 + dx / 2 + 9, y1 + dy / 2 - 2);
        }
        AffineTransform oldTransform = g$2.getTransform();
        AffineTransform at = (AffineTransform)oldTransform.clone();
        at.concatenate(AffineTransform.getTranslateInstance(x1, y1));
        at.concatenate(AffineTransform.getRotateInstance(angle));
        g$2.setTransform(at);
        g$2.drawLine(0, 0, len, 0);
        if (s != null) {
            g$2.fillPolygon(new int[]{len, len - ARROW_HEAD_L, len - ARROW_HEAD_L, len}, new int[]{0, -ARROW_HEAD_W, ARROW_HEAD_W, 0}, 4);
        }
        g$2.setTransform(oldTransform);
        GraphicalDebugger$class.emphasize$2($this, false, g$2);
    }

    private static final String getBreakText$1(GraphicalDebugger $this, Enumeration.Value a) {
        Enumeration.Value value = a;
        Enumeration.Value value2 = ActivationMode$.MODULE$.Optional();
        Enumeration.Value value3 = value;
        String string = !(value2 != null ? !value2.equals(value3) : value3 != null) ? "Optional Break" : "Break";
        return string;
    }

    /*
     * Unable to fully structure code
     */
    public static final void drawEdge$2(GraphicalDebugger $this, CallGraphNode p, double pwx, int pwy, CallGraphNode c, double cwx, int cwy, int GRID_W$2, int GRID_H$2, int BOX_W$2, int BOX_H$2, int hOffset$2, int vOffset$2, Graphics2D g$2) {
        block5: {
            block7: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                block4: {
                                    pHCenter = (int)(pwx * (double)GRID_W$2) + BOX_W$2 / 2 + hOffset$2;
                                    pBottom = pwy * GRID_H$2 + BOX_H$2 + vOffset$2;
                                    cHCenter = (int)(cwx * (double)GRID_W$2) + BOX_W$2 / 2 + hOffset$2;
                                    cTop = cwy * GRID_H$2 + vOffset$2;
                                    x1 = pHCenter;
                                    y1 = pBottom;
                                    x2 = cHCenter;
                                    y2 = cTop;
                                    if ($this.currentMessage() != null) break block4;
                                    v0 = null;
                                    break block5;
                                }
                                var25_22 = false;
                                var26_23 = null;
                                var27_24 = $this.currentMessage();
                                if (!(var27_24 instanceof AAHappened)) break block6;
                                var28_25 = (AAHappened)var27_24;
                                mp = var28_25.node();
                                mc = var28_25.child();
                                if (p.index() != mp.index() || c.index() != mc.index()) break block6;
                                var31_28 = "AA Happened";
                                break block7;
                            }
                            if (!(var27_24 instanceof SuccessMsg)) break block8;
                            var25_22 = true;
                            var26_23 = (SuccessMsg)var27_24;
                            var32_29 = var26_23.child();
                            if (var32_29 != null) break block8;
                            var31_28 = null;
                            break block7;
                        }
                        if (!var25_22) break block9;
                        mp = var26_23.node();
                        mc = var26_23.child();
                        if (p.index() != mp.index() || c.index() != mc.index()) break block9;
                        var31_28 = "Success";
                        break block7;
                    }
                    if (!(var27_24 instanceof Break)) break block10;
                    var35_32 = (Break)var27_24;
                    mp = var35_32.node();
                    mc = var35_32.child();
                    mode = var35_32.activationMode();
                    if (p.index() != mp.index() || c.index() != mc.index()) break block10;
                    var31_28 = GraphicalDebugger$class.getBreakText$1($this, mode);
                    break block7;
                }
                if (!(var27_24 instanceof Exclude)) ** GOTO lbl-1000
                var39_36 = (Exclude)var27_24;
                mp = var39_36.parent();
                mc = var39_36.node();
                if (p.index() == mp.index() && c.index() == mc.index()) {
                    var31_28 = "Exclude";
                } else lbl-1000:
                // 2 sources

                {
                    var31_28 = null;
                }
            }
            v0 = var31_28;
        }
        text = v0;
        doDownwards = $this.currentMessage() instanceof Exclude;
        if (doDownwards) {
            GraphicalDebugger$class.drawArrow$1($this, x1, y1, x2, y2, text, g$2);
        } else {
            GraphicalDebugger$class.drawArrow$1($this, x2, y2, x1, y1, text, g$2);
        }
        g$2.setStroke($this.normalStroke());
        g$2.setColor(Color.black);
    }

    /*
     * Unable to fully structure code
     */
    private static final void drawContinuationTexts$1(GraphicalDebugger $this, CallGraphNode n, int boxRight, int boxTop, Graphics2D g$2) {
        block7: {
            block6: {
                x = boxRight + 3;
                y = IntRef.create((int)boxTop);
                var7_7 = n;
                if (!(var7_7 instanceof N_n_ary_op) || (var8_8 = (N_n_ary_op)var7_7).continuation() == null) break block6;
                fontMetrics = g$2.getFontMetrics();
                $this.interestingContinuationInternals(var8_8.continuation()).foreach((Function1)new Serializable($this, x, y, fontMetrics, g$2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GraphicalDebugger $outer;
                    private final int x$8;
                    private final IntRef y$1;
                    private final FontMetrics fontMetrics$1;
                    private final Graphics2D g$2;

                    public final void apply(String s) {
                        this.$outer.drawStringTopLeft(this.g$2, s, this.x$8, this.y$1.elem);
                        this.y$1.elem += this.fontMetrics$1.getHeight() - 2;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.x$8 = x$8;
                        this.y$1 = y$1;
                        this.fontMetrics$1 = fontMetrics$1;
                        this.g$2 = g$2;
                    }
                });
                var9_10 = BoxedUnit.UNIT;
                break block7;
            }
            if ($this.currentMessage() == null) ** GOTO lbl-1000
            v0 = $this.currentMessage().node();
            var11_12 = n;
            if (!(v0 != null ? v0.equals(var11_12) == false : var11_12 != null)) {
                var12_13 = $this.currentMessage();
                if (var12_13 instanceof SuccessMsg && (var13_14 = (SuccessMsg)var12_13).child() == null) {
                    $this.drawStringTopLeft(g$2, "Success", x, y.elem);
                    var14_15 = BoxedUnit.UNIT;
                } else if (var12_13 instanceof AAHappened && (var15_18 = (AAHappened)var12_13).child() == null) {
                    $this.drawStringTopLeft(g$2, "AA Happened", x, y.elem);
                    var14_16 = BoxedUnit.UNIT;
                } else {
                    var14_17 = BoxedUnit.UNIT;
                }
                v1 = BoxedUnit.UNIT;
            } else lbl-1000:
            // 2 sources

            {
                v1 = BoxedUnit.UNIT;
            }
            var9_11 = v1;
        }
    }

    public static final Tuple2 drawTree$1(GraphicalDebugger $this, CallGraphNode n, double xGrid, int yGrid, int GRID_W$2, int GRID_H$2, int BOX_W$2, int BOX_H$2, int hOffset$2, int vOffset$2, Graphics2D g$2) {
        CallGraphNode callGraphNode;
        String string;
        DoubleRef resultW = DoubleRef.create((double)0.0);
        ObjectRef childHCs = ObjectRef.create((Object)new ListBuffer());
        boolean isCurrentNode = $this.currentMessage() != null && $this.currentMessage().node().index() == n.index();
        CallGraphNode callGraphNode2 = n;
        if (callGraphNode2 != null) {
            BoxedUnit boxedUnit;
            CallGraphNode callGraphNode3 = callGraphNode2;
            int pcl = callGraphNode3.children().length();
            if (pcl == 0) {
                resultW.elem = 1.0;
                boxedUnit = BoxedUnit.UNIT;
            } else {
                callGraphNode3.children().foreach((Function1)new Serializable($this, GRID_W$2, GRID_H$2, BOX_W$2, BOX_H$2, hOffset$2, vOffset$2, xGrid, yGrid, resultW, childHCs, g$2){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ GraphicalDebugger $outer;
                    private final int GRID_W$2;
                    private final int GRID_H$2;
                    private final int BOX_W$2;
                    private final int BOX_H$2;
                    private final int hOffset$2;
                    private final int vOffset$2;
                    private final double xGrid$2;
                    private final int yGrid$2;
                    private final DoubleRef resultW$2;
                    private final ObjectRef childHCs$2;
                    private final Graphics2D g$2;

                    public final ListBuffer<Object> apply(CallGraphNode c) {
                        Tuple2 tuple2 = GraphicalDebugger$class.drawTree$1(this.$outer, c, this.xGrid$2 + this.resultW$2.elem, this.yGrid$2 + 1, this.GRID_W$2, this.GRID_H$2, this.BOX_W$2, this.BOX_H$2, this.hOffset$2, this.vOffset$2, this.g$2);
                        if (tuple2 != null) {
                            Tuple2.mcDD.sp sp2;
                            double childW = tuple2._1$mcD$sp();
                            double childHC = tuple2._2$mcD$sp();
                            Tuple2.mcDD.sp sp3 = sp2 = new Tuple2.mcDD.sp(childW, childHC);
                            double childW2 = sp3._1$mcD$sp();
                            double childHC2 = sp3._2$mcD$sp();
                            this.resultW$2.elem += childW2;
                            return ((ListBuffer)this.childHCs$2.elem).$plus$eq((Object)BoxesRunTime.boxToDouble((double)childHC2));
                        }
                        throw new MatchError((Object)tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.GRID_W$2 = GRID_W$2;
                        this.GRID_H$2 = GRID_H$2;
                        this.BOX_W$2 = BOX_W$2;
                        this.BOX_H$2 = BOX_H$2;
                        this.hOffset$2 = hOffset$2;
                        this.vOffset$2 = vOffset$2;
                        this.xGrid$2 = xGrid$2;
                        this.yGrid$2 = yGrid$2;
                        this.resultW$2 = resultW$2;
                        this.childHCs$2 = childHCs$2;
                        this.g$2 = g$2;
                    }
                });
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            resultW.elem = 1.0;
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        double thisX = xGrid + (resultW.elem - 1.0) / (double)2;
        int boxLeft = (int)(thisX * (double)GRID_W$2) + hOffset$2;
        int boxTop = yGrid * GRID_H$2 + vOffset$2;
        int boxRight = boxLeft + BOX_W$2;
        int boxBottom = boxTop + BOX_H$2;
        int hCenter = boxLeft + BOX_W$2 / 2;
        int vCenter = boxTop + BOX_H$2 / 2;
        CallGraphNode callGraphNode4 = n;
        if (callGraphNode4 instanceof ScriptNode) {
            ScriptNode scriptNode = (ScriptNode)callGraphNode4;
            string = scriptNode.template().name().name();
        } else if (callGraphNode4 instanceof N_n_ary_op) {
            N_n_ary_op n_n_ary_op = (N_n_ary_op)callGraphNode4;
            string = new StringBuilder().append((Object)n_n_ary_op.template().kind()).append((Object)(n_n_ary_op.isIteration() ? " ..." : "")).toString();
        } else {
            string = n.template().kind();
        }
        String s = string;
        CallGraphNode callGraphNode5 = n;
        boolean bl = callGraphNode5 instanceof Script ? true : callGraphNode5 instanceof N_call;
        Font font = bl ? $this.smallFont() : $this.normalFont();
        Font nameFont = font;
        Rectangle r = new Rectangle(boxLeft, boxTop, BOX_W$2, BOX_H$2);
        g$2.setColor($this.fillColor(n, $this.lightGreen(), true));
        g$2.fill(r);
        GraphicalDebugger$class.emphasize$2($this, isCurrentNode, g$2);
        g$2.draw(r);
        if (isCurrentNode) {
            CallGraphMessage callGraphMessage = $this.currentMessage();
            if (callGraphMessage instanceof Deactivation) {
                CallGraphNode callGraphNode6;
                Deactivation deactivation = (Deactivation)callGraphMessage;
                CallGraphNode callGraphNode7 = n;
                if (callGraphNode7 instanceof N_n_ary_op && deactivation.child() != null) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (callGraphNode7 != null && (callGraphNode6 = callGraphNode7).children().length() > 0) {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    g$2.drawLine(boxLeft, boxTop, boxRight, boxBottom);
                    g$2.drawLine(boxLeft, boxBottom, boxRight, boxTop);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        GraphicalDebugger$class.emphasize$2($this, false, g$2);
        g$2.setFont($this.smallFont());
        GraphicalDebugger$class.drawContinuationTexts$1($this, n, boxRight, boxTop, g$2);
        $this.drawStringTopLeft(g$2, ((Object)BoxesRunTime.boxToInteger((int)n.index())).toString(), boxLeft + 2, boxTop + 5);
        if (n.hasSuccess()) {
            $this.drawStringTopRight(g$2, "S", boxRight - 1, boxTop + 5);
        }
        g$2.setFont(nameFont);
        $this.drawStringCentered(g$2, s, hCenter, vCenter);
        CallGraphNode callGraphNode8 = n;
        if (callGraphNode8 instanceof N_n_ary_op) {
            BoxedUnit boxedUnit;
            N_n_ary_op n_n_ary_op = (N_n_ary_op)callGraphNode8;
            Enumeration.Value value = n_n_ary_op.activationMode();
            Enumeration.Value value2 = ActivationMode$.MODULE$.Active();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value3 = n_n_ary_op.activationMode();
                Enumeration.Value value4 = ActivationMode$.MODULE$.Inactive();
                String s2 = !(value3 != null ? !value3.equals(value4) : value4 != null) ? "." : "-";
                g$2.setFont($this.smallFont());
                $this.drawStringTopLeft(g$2, s2, boxRight - 7, boxTop + 5);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit3 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        CallGraphNode callGraphNode9 = n;
        if (callGraphNode9 != null && !(callGraphNode = callGraphNode9).children().isEmpty()) {
            ((IterableLike)callGraphNode.children().zip((GenIterable)((ListBuffer)childHCs.elem), Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable($this, GRID_W$2, GRID_H$2, BOX_W$2, BOX_H$2, hOffset$2, vOffset$2, n, yGrid, thisX, g$2){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ GraphicalDebugger $outer;
                private final int GRID_W$2;
                private final int GRID_H$2;
                private final int BOX_W$2;
                private final int BOX_H$2;
                private final int hOffset$2;
                private final int vOffset$2;
                private final CallGraphNode n$1;
                private final int yGrid$2;
                private final double thisX$2;
                private final Graphics2D g$2;

                public final void apply(Tuple2<CallGraphNode, Object> c_hc) {
                    GraphicalDebugger$class.drawEdge$2(this.$outer, this.n$1, this.thisX$2, this.yGrid$2, (CallGraphNode)c_hc._1(), c_hc._2$mcD$sp(), this.yGrid$2 + 1, this.GRID_W$2, this.GRID_H$2, this.BOX_W$2, this.BOX_H$2, this.hOffset$2, this.vOffset$2, this.g$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.GRID_W$2 = GRID_W$2;
                    this.GRID_H$2 = GRID_H$2;
                    this.BOX_W$2 = BOX_W$2;
                    this.BOX_H$2 = BOX_H$2;
                    this.hOffset$2 = hOffset$2;
                    this.vOffset$2 = vOffset$2;
                    this.n$1 = n$1;
                    this.yGrid$2 = yGrid$2;
                    this.thisX$2 = thisX$2;
                    this.g$2 = g$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return new Tuple2.mcDD.sp(resultW.elem, thisX);
    }

    public static void $init$(GraphicalDebugger $this) {
        $this.subscript$swing$GraphicalDebugger$$_otherScriptExecutor_$eq(null);
        $this.vmThread_$eq(null);
        $this.messageBeingHandled_$eq(false);
        $this.currentMessage_$eq(null);
        $this.subscript$swing$GraphicalDebugger$_setter_$exitButton_$eq(new Button($this){
            {
                this.enabled_$eq(false);
                this.defaultCapable_$eq(false);
                this.focusable_$eq(false);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$stepButton_$eq(new Button($this){
            {
                this.enabled_$eq(false);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Activation_$eq(new CheckBox($this){
            {
                this.text_$eq("Act");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Deactivation_$eq(new CheckBox($this){
            {
                this.text_$eq("Dea");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_AAToBeExecuted_$eq(new CheckBox($this){
            {
                this.text_$eq("AAT");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Continuation_$eq(new CheckBox($this){
            {
                this.text_$eq("Cnt");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_AAHappened_$eq(new CheckBox($this){
            {
                this.text_$eq("AAH");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Success_$eq(new CheckBox($this){
            {
                this.text_$eq("Scs");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Break_$eq(new CheckBox($this){
            {
                this.text_$eq("Brk");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Exclude_$eq(new CheckBox($this){
            {
                this.text_$eq("Exc");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_step_Wait_$eq(new CheckBox($this){
            {
                this.text_$eq("Idle");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Activation_$eq(new CheckBox($this){
            {
                this.text_$eq("Act");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Deactivation_$eq(new CheckBox($this){
            {
                this.text_$eq("Dea");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_AAToBeExecuted_$eq(new CheckBox($this){
            {
                this.text_$eq("AAT");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Continuation_$eq(new CheckBox($this){
            {
                this.text_$eq("Cnt");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_AAHappened_$eq(new CheckBox($this){
            {
                this.text_$eq("AAH");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Success_$eq(new CheckBox($this){
            {
                this.text_$eq("Scs");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Break_$eq(new CheckBox($this){
            {
                this.text_$eq("Brk");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Exclude_$eq(new CheckBox($this){
            {
                this.text_$eq("Exc");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$checkBox_log_Wait_$eq(new CheckBox($this){
            {
                this.text_$eq("Idle");
                this.selected_$eq(true);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$buttonsPanel_$eq(new BoxPanel($this){
            {
                this.contents().$plus$eq((Object)new Label("Step:"));
                this.contents().$plus$eq((Object)$outer.checkBox_step_Activation());
                this.contents().$plus$eq((Object)$outer.checkBox_step_Deactivation());
                this.contents().$plus$eq((Object)$outer.checkBox_step_AAToBeExecuted());
                this.contents().$plus$eq((Object)$outer.checkBox_step_Continuation());
                this.contents().$plus$eq((Object)$outer.checkBox_step_AAHappened());
                this.contents().$plus$eq((Object)$outer.checkBox_step_Success());
                this.contents().$plus$eq((Object)$outer.checkBox_step_Break());
                this.contents().$plus$eq((Object)$outer.checkBox_step_Exclude());
                this.contents().$plus$eq((Object)$outer.checkBox_step_Wait());
                this.contents().$plus$eq((Object)new Label("  ---  "));
                this.contents().$plus$eq((Object)new Label("Log:"));
                this.contents().$plus$eq((Object)$outer.checkBox_log_Activation());
                this.contents().$plus$eq((Object)$outer.checkBox_log_Deactivation());
                this.contents().$plus$eq((Object)$outer.checkBox_log_AAToBeExecuted());
                this.contents().$plus$eq((Object)$outer.checkBox_log_Continuation());
                this.contents().$plus$eq((Object)$outer.checkBox_log_AAHappened());
                this.contents().$plus$eq((Object)$outer.checkBox_log_Success());
                this.contents().$plus$eq((Object)$outer.checkBox_log_Break());
                this.contents().$plus$eq((Object)$outer.checkBox_log_Exclude());
                this.contents().$plus$eq((Object)$outer.checkBox_log_Wait());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$callGraphPanel_$eq(new Panel($this){
            private final /* synthetic */ GraphicalDebugger $outer;

            public void paint(Graphics2D g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.size().width, this.size().height);
                try {
                    this.$outer.onPaintCallGraph(g);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.background_$eq(Color.white);
                this.preferredSize_$eq(new Dimension(3000, 2000));
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$templateTreesPanel_$eq(new Panel($this){
            private final /* synthetic */ GraphicalDebugger $outer;

            public void paint(Graphics2D g) {
                g.setColor(Color.white);
                g.fillRect(0, 0, this.size().width, this.size().height);
                this.$outer.onPaintTemplateTrees(g);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.background_$eq(Color.white);
                this.preferredSize_$eq(new Dimension(4600, 900));
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$fixedWidthFont_$eq(new Font("Monaco", 0, 14));
        $this.subscript$swing$GraphicalDebugger$_setter_$currentMsgFont_$eq(new Font("Monaco", 1, 14));
        $this.subscript$swing$GraphicalDebugger$_setter_$normalFont_$eq(new Font("Arial", 1, 16));
        $this.subscript$swing$GraphicalDebugger$_setter_$smallFont_$eq(new Font("Arial", 1, 13));
        $this.subscript$swing$GraphicalDebugger$_setter_$normalStroke_$eq(new BasicStroke(1.0f));
        $this.subscript$swing$GraphicalDebugger$_setter_$fatStroke_$eq(new BasicStroke(3.0f));
        $this.subscript$swing$GraphicalDebugger$_setter_$lightOrange_$eq(new Color(255, 238, 220));
        $this.subscript$swing$GraphicalDebugger$_setter_$lightGreen_$eq(new Color(220, 255, 220));
        $this.subscript$swing$GraphicalDebugger$_setter_$lightBlue_$eq(new Color(220, 220, 255));
        $this.subscript$swing$GraphicalDebugger$_setter_$lightRed_$eq(new Color(255, 220, 220));
        $this.subscript$swing$GraphicalDebugger$_setter_$lightPurple_$eq(new Color(255, 220, 255));
        $this.subscript$swing$GraphicalDebugger$_setter_$maxLogListMsgs_$eq(5000);
        $this.subscript$swing$GraphicalDebugger$_setter_$logListMsgsCleanups_$eq(1000);
        $this.subscript$swing$GraphicalDebugger$_setter_$msgLogListModel_$eq(new DefaultListModel());
        $this.subscript$swing$GraphicalDebugger$_setter_$msgQueueListModel_$eq(new DefaultListModel());
        $this.subscript$swing$GraphicalDebugger$_setter_$currentMessageTF_$eq(new TextField($this){
            {
                this.editable_$eq(false);
                this.font_$eq($outer.currentMsgFont());
                this.background_$eq($outer.lightBlue());
                this.horizontalAlignment_$eq(Alignment$.MODULE$.Left());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$msgLogList_$eq(new ListBuffer());
        $this.subscript$swing$GraphicalDebugger$_setter_$msgQueueList_$eq(new ListBuffer());
        $this.subscript$swing$GraphicalDebugger$_setter_$msgLogListView_$eq((ListView)new ListView<String>($this){
            {
                this.font_$eq($outer.fixedWidthFont());
                this.peer().setModel($outer.msgLogListModel());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$msgQueueListView_$eq((ListView)new ListView<String>($this){
            {
                this.font_$eq($outer.fixedWidthFont());
                this.peer().setModel($outer.msgQueueListModel());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$msgLogListViewScrollPane_$eq(new ScrollPane($this){
            {
                this.contents_$eq((Component)$outer.msgLogListView());
                this.verticalScrollBarPolicy_$eq(ScrollPane.BarPolicy$.MODULE$.Always());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$msgQueueListViewScrollPane_$eq(new ScrollPane($this){
            {
                this.contents_$eq((Component)$outer.msgQueueListView());
                this.verticalScrollBarPolicy_$eq(ScrollPane.BarPolicy$.MODULE$.Always());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$borderPanelMsgs_$eq(new BorderPanel($this){
            {
                this.add((Component)$outer.msgLogListViewScrollPane(), BorderPanel.Position$.MODULE$.Center());
                this.add((Component)$outer.currentMessageTF(), BorderPanel.Position$.MODULE$.South());
            }
        });
        $this.splitPaneMain_$eq(null);
        $this.subscript$swing$GraphicalDebugger$_setter_$doTemplateTreeTopLeft_$eq(true);
        if ($this.doTemplateTreeTopLeft()) {
            SplitPane splitPaneMsgs = new SplitPane($this){
                {
                    this.dividerLocation_$eq(250);
                }
            };
            SplitPane splitPaneTreesMsgs = new SplitPane($this, splitPaneMsgs){
                {
                    this.dividerLocation_$eq(250);
                }
            };
            SplitPane splitPaneLeft = new SplitPane($this, splitPaneTreesMsgs){
                {
                    this.dividerLocation_$eq(60);
                }
            };
            $this.splitPaneMain_$eq(new SplitPane($this, splitPaneLeft){
                {
                    this.dividerLocation_$eq(400);
                }
            });
        } else {
            SplitPane splitPaneGraphs = new SplitPane($this){
                {
                    this.dividerLocation_$eq(178);
                }
            };
            SplitPane splitPaneMsgs = new SplitPane($this){
                {
                    this.dividerLocation_$eq(350);
                }
            };
            $this.splitPaneMain_$eq(new SplitPane($this, splitPaneGraphs, splitPaneMsgs){
                {
                    this.dividerLocation_$eq(240);
                }
            });
        }
        $this.subscript$swing$GraphicalDebugger$_setter_$descriptionTF_$eq(new TextField($this){
            {
                this.preferredSize_$eq(new Dimension(400, 24));
                this.editable_$eq(false);
                this.font_$eq($outer.fixedWidthFont());
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$autoCheckBox_$eq(new CheckBox($this){
            {
                this.text_$eq("Auto");
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$speedSlider_$eq(new Slider($this){
            {
                this.min_$eq(0);
                this.max_$eq(10);
                this.value_$eq(5);
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$top_$eq(new Frame($this){
            private final /* synthetic */ GraphicalDebugger $outer;

            public /* synthetic */ GraphicalDebugger subscript$swing$GraphicalDebugger$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super(Frame$.MODULE$.$lessinit$greater$default$1());
                this.title_$eq("Subscript Graphical Debugger");
                this.location_$eq(new Point(0, 0));
                this.preferredSize_$eq(new Dimension(900, 700));
                this.contents_$eq((Component)new BorderPanel(this){
                    {
                        this.add((Component)new FlowPanel((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Component[]{$outer.subscript$swing$GraphicalDebugger$$anon$$$outer().descriptionTF(), $outer.subscript$swing$GraphicalDebugger$$anon$$$outer().stepButton(), $outer.subscript$swing$GraphicalDebugger$$anon$$$outer().autoCheckBox(), $outer.subscript$swing$GraphicalDebugger$$anon$$$outer().speedSlider(), $outer.subscript$swing$GraphicalDebugger$$anon$$$outer().exitButton()})), BorderPanel.Position$.MODULE$.North());
                        this.add((Component)$outer.subscript$swing$GraphicalDebugger$$anon$$$outer().splitPaneMain(), BorderPanel.Position$.MODULE$.Center());
                    }
                });
            }
        });
        $this.subscript$swing$GraphicalDebugger$_setter_$myScriptExecutor_$eq(ScriptExecutorFactory$.MODULE$.createScriptExecutor($this.doesThisAllowToBeDebugged()));
        $this.myScriptExecutor().name_$eq("myScriptExecutor");
        $this.exitConfirmed_$eq(false);
    }
}

