/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final double maxPreciseDouble;
    private final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private final Map<TimeUnit, String> timeUnitName;
    private final Map<String, TimeUnit> timeUnit;
    private final long \u00b5s_per_ns;
    private final long ms_per_ns;
    private final long s_per_ns;
    private final long min_per_ns;
    private final long h_per_ns;
    private final long d_per_ns;
    private final FiniteDuration Zero;
    private final Duration.Infinite Undefined;
    private final Duration.Infinite Inf;
    private final Duration.Infinite MinusInf;

    static {
        new Duration$();
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    public Duration apply(String s2) {
        block5: {
            Duration duration;
            block3: {
                String s1;
                block4: {
                    String string2;
                    block2: {
                        s1 = (String)new StringOps(Predef$.MODULE$.augmentString(s2)).filterNot((Function1)((Object)new Serializable(){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(char x$1) {
                                return RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(x$1));
                            }
                        }));
                        string2 = s1;
                        boolean bl = "Inf".equals(string2) ? true : ("PlusInf".equals(string2) ? true : "+Inf".equals(string2));
                        if (!bl) break block2;
                        duration = this.Inf();
                        break block3;
                    }
                    boolean bl = "MinusInf".equals(string2) ? true : "-Inf".equals(string2);
                    if (!bl) break block4;
                    duration = this.MinusInf();
                    break block3;
                }
                String unitName = (String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString((String)new StringOps(Predef$.MODULE$.augmentString(s1)).reverse())).takeWhile((Function1)((Object)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(char x$2) {
                        return RichChar$.MODULE$.isLetter$extension(Predef$.MODULE$.charWrapper(x$2));
                    }
                })))).reverse();
                Option option = this.timeUnit().get(unitName);
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                TimeUnit unit = (TimeUnit)((Object)some.x());
                String valueStr = (String)new StringOps(Predef$.MODULE$.augmentString(s1)).dropRight(unitName.length());
                double valueD = Double.parseDouble(valueStr);
                FiniteDuration finiteDuration = valueD >= -9.007199254740992E15 && valueD <= 9.007199254740992E15 ? this.apply(valueD, unit) : this.apply(Long.parseLong(valueStr), unit);
                duration = finiteDuration;
            }
            return duration;
        }
        throw new NumberFormatException(new StringBuilder().append((Object)"format error ").append((Object)s2).toString());
    }

    public List<String> scala$concurrent$duration$Duration$$words(String s2) {
        return Predef$.MODULE$.refArrayOps((Object[])s2.trim().split("\\s+")).toList();
    }

    public List<String> scala$concurrent$duration$Duration$$expandLabels(String labels) {
        List<String> list = this.scala$concurrent$duration$Duration$$words(labels);
        if (list instanceof $colon$colon) {
            Tuple2 tuple2;
            $colon$colon $colon$colon = ($colon$colon)list;
            String hd = (String)$colon$colon.head();
            List rest = $colon$colon.tl$1();
            Tuple2 tuple22 = tuple2 = new Tuple2(hd, rest);
            String hd2 = tuple22._1();
            List<String> rest2 = tuple22._2();
            String string2 = hd2;
            return rest2.flatMap(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<String> apply(String s2) {
                    return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{s2, new StringBuilder().append((Object)s2).append((Object)"s").toString()}));
                }
            }, List$.MODULE$.canBuildFrom()).$colon$colon(string2);
        }
        throw new MatchError(list);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return this.timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return this.timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s2) {
        return this.liftedTree1$1(s2).flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<Tuple2<Object, TimeUnit>> apply(Duration d) {
                return Duration$.MODULE$.unapply(d);
            }
        });
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.isFinite() ? new Some<Tuple2<Long, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit())) : None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        Duration duration;
        if (Predef$.MODULE$.double2Double(nanos).isInfinite()) {
            duration = nanos > 0.0 ? this.Inf() : this.MinusInf();
        } else if (Predef$.MODULE$.double2Double(nanos).isNaN()) {
            duration = this.Undefined();
        } else {
            if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"trying to construct too large duration with ").append(BoxesRunTime.boxToDouble(nanos)).append((Object)"ns").toString());
            }
            duration = this.fromNanos((long)(nanos + 0.5));
        }
        return duration;
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration.Infinite Undefined() {
        return this.Undefined;
    }

    public Duration.Infinite Inf() {
        return this.Inf;
    }

    public Duration.Infinite MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s2) {
        return this.apply(s2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Option liftedTree1$1(String s$1) {
        Option option;
        try {
            option = new Some<Duration>(this.apply(s$1));
        }
        catch (RuntimeException runtimeException) {
            option = None$.MODULE$;
        }
        return option;
    }

    private Duration$() {
        MODULE$ = this;
        this.timeUnitLabels = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.DAYS), "d day"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.HOURS), "h hour"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.MINUTES), "min minute"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.SECONDS), "s sec second"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.MILLISECONDS), "ms milli millisecond"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.MICROSECONDS), "\u00b5s micro microsecond"), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TimeUnit.NANOSECONDS), "ns nano nanosecond")}));
        this.timeUnitName = this.timeUnitLabels.toMap(Predef$.MODULE$.$conforms()).mapValues(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String s2) {
                return Duration$.MODULE$.scala$concurrent$duration$Duration$$words(s2).last();
            }
        }).toMap(Predef$.MODULE$.$conforms());
        this.timeUnit = ((TraversableOnce)this.timeUnitLabels.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Tuple2<String, TimeUnit>> apply(Tuple2<TimeUnit, String> x0$1) {
                Tuple2<TimeUnit, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    TimeUnit unit = tuple2._1();
                    String names = tuple2._2();
                    List<Tuple2<String, TimeUnit>> list = Duration$.MODULE$.scala$concurrent$duration$Duration$$expandLabels(names).map(new Serializable(this, unit){
                        public static final long serialVersionUID = 0L;
                        private final TimeUnit unit$1;

                        public final Tuple2<String, TimeUnit> apply(String x$5) {
                            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(x$5), this.unit$1);
                        }
                        {
                            this.unit$1 = unit$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        this.Undefined = new Duration.Infinite(){

            public String toString() {
                return "Duration.Undefined";
            }

            public boolean equals(Object other) {
                return false;
            }

            public Duration $plus(Duration other) {
                return this;
            }

            public Duration $minus(Duration other) {
                return this;
            }

            public Duration $times(double factor) {
                return this;
            }

            public Duration $div(double factor) {
                return this;
            }

            public double $div(Duration other) {
                return Double.NaN;
            }

            public int compare(Duration other) {
                return other == this ? 0 : 1;
            }

            public Duration unary_$minus() {
                return this;
            }

            public double toUnit(TimeUnit unit) {
                return Double.NaN;
            }
        };
        this.Inf = new Duration.Infinite(){

            public String toString() {
                return "Duration.Inf";
            }

            public int compare(Duration other) {
                Duration duration = other;
                int n = duration == Duration$.MODULE$.Undefined() ? -1 : (duration == this ? 0 : 1);
                return n;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.POSITIVE_INFINITY;
            }
        };
        this.MinusInf = new Duration.Infinite(){

            public String toString() {
                return "Duration.MinusInf";
            }

            public int compare(Duration other) {
                return other == this ? 0 : -1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.NEGATIVE_INFINITY;
            }
        };
    }
}

