/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.subethamail.smtp.util.TextUtils;

public class ReceivedHeaderStream
extends FilterInputStream {
    ByteArrayInputStream header;

    public ReceivedHeaderStream(InputStream in, String heloHost, InetAddress host, String whoami, String softwareName, String id, String singleRecipient) {
        super(in);
        SimpleDateFormat fmt = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z (z)", Locale.US);
        String timestamp = fmt.format(new Date());
        StringBuilder header = new StringBuilder();
        header.append("Received: from " + heloHost + " (" + this.constructTcpInfo(host) + ")\r\n");
        header.append("        by " + whoami + "\r\n");
        header.append("        with SMTP");
        if (softwareName != null) {
            header.append(" (" + softwareName + ")");
        }
        header.append(" id ").append(id);
        if (singleRecipient != null) {
            header.append("\r\n        for " + singleRecipient);
        }
        header.append(";\r\n");
        header.append("        " + timestamp + "\r\n");
        this.header = new ByteArrayInputStream(TextUtils.getAsciiBytes(header.toString()));
    }

    private String constructTcpInfo(InetAddress host) {
        String address;
        String domain = host.getCanonicalHostName();
        if (domain.equals(address = host.getHostAddress())) {
            return "[" + address + "]";
        }
        return domain + " [" + address + "]";
    }

    public int available() throws IOException {
        return this.header.available() + super.available();
    }

    public void close() throws IOException {
        super.close();
    }

    public synchronized void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        if (this.header.available() > 0) {
            return this.header.read();
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.header.available() > 0) {
            int countRead = this.header.read(b, off, len);
            if (countRead < len) {
                int remainder = len - countRead;
                int additionalRead = super.read(b, off + countRead, remainder);
                return countRead + additionalRead;
            }
            return countRead;
        }
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

