/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.transform;

import java.util.Map;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.app.StructrApp;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.script.Scripting;
import org.structr.schema.action.ActionContext;

public class Transformation {
    private String sourceName = null;
    private String targetName = null;
    private String inputFunction = null;
    private String outputFunction = null;
    private PropertyKey sourceProperty = null;
    private PropertyKey targetProperty = null;

    public Transformation(Class type, String sourceName, String targetName, String inputFunction, String outputFunction) {
        this.sourceName = sourceName;
        this.targetName = targetName;
        this.inputFunction = inputFunction;
        this.outputFunction = outputFunction;
        this.sourceProperty = StructrApp.getConfiguration().getPropertyKeyForJSONName(type, sourceName);
        this.targetProperty = new GenericProperty(targetName);
    }

    public Object transformOutput(ActionContext actionContext, GraphObject source) throws FrameworkException {
        if (this.outputFunction == null) {
            return source.getProperty(this.sourceProperty);
        }
        actionContext.setConstant("input", (Object)source);
        return Scripting.evaluate((ActionContext)actionContext, null, (String)("${" + this.outputFunction + "}"));
    }

    public void transformInput(ActionContext actionContext, Map<String, Object> source) throws FrameworkException {
        Object inputValue = source.remove(this.targetName);
        if (inputValue != null) {
            if (this.inputFunction != null) {
                actionContext.setConstant("input", inputValue);
                inputValue = Scripting.evaluate((ActionContext)actionContext, null, (String)("${" + this.inputFunction + "}"));
            }
            source.put(this.sourceName, inputValue);
        }
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public PropertyKey getSourceProperty() {
        return this.sourceProperty;
    }

    public PropertyKey getTargetProperty() {
        return this.targetProperty;
    }
}

