/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.servlet;

import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.Value;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.auth.Authenticator;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.resource.Resource;
import org.structr.rest.service.HttpServiceServlet;
import org.structr.rest.service.StructrHttpServiceConfig;
import org.structr.rest.servlet.ResourceHelper;

public class CsvServlet
extends HttpServlet
implements HttpServiceServlet {
    private static final Logger logger = Logger.getLogger(CsvServlet.class.getName());
    private static final String DELIMITER = ";";
    private static final String REMOVE_LINE_BREAK_PARAM = "nolinebreaks";
    private static final String WRITE_BOM = "bom";
    private final Map<Pattern, Class<? extends Resource>> resourceMap = new LinkedHashMap<Pattern, Class<? extends Resource>>();
    private Value<String> propertyView = null;
    private static boolean removeLineBreaks = false;
    private static boolean writeBom = false;
    private String defaultPropertyView;
    private final StructrHttpServiceConfig config = new StructrHttpServiceConfig();

    @Override
    public StructrHttpServiceConfig getConfig() {
        return this.config;
    }

    public void init() {
        this.resourceMap.putAll(this.config.getResourceProvider().getResources());
        this.propertyView = new ThreadLocalPropertyView();
        this.defaultPropertyView = this.config.getDefaultPropertyView();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws UnsupportedEncodingException {
        SecurityContext securityContext = null;
        Authenticator authenticator = null;
        Result result = null;
        Resource resource = null;
        try {
            try (Tx tx = StructrApp.getInstance().tx();){
                authenticator = this.config.getAuthenticator();
                securityContext = authenticator.initializeAndExamineRequest(request, response);
                tx.success();
            }
            App app = StructrApp.getInstance((SecurityContext)securityContext);
            request.setCharacterEncoding("UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/csv; charset=utf-8");
            this.propertyView.set(securityContext, (Object)this.defaultPropertyView);
            double queryTimeStart = System.nanoTime();
            try (Tx tx = app.tx();){
                resource = ResourceHelper.optimizeNestedResourceChain(securityContext, request, this.resourceMap, this.propertyView);
                authenticator.checkResourceAccess(securityContext, request, resource.getResourceSignature(), (String)this.propertyView.get(securityContext));
                tx.success();
            }
            tx = app.tx();
            var11_22 = null;
            try {
                String resourceSignature = resource.getResourceSignature();
                authenticator.checkResourceAccess(securityContext, request, resourceSignature, (String)this.propertyView.get(securityContext));
                String pageSizeParameter = request.getParameter("pageSize");
                String pageParameter = request.getParameter("page");
                String offsetId = request.getParameter("pageStartId");
                String sortOrder = request.getParameter("order");
                String sortKeyName = request.getParameter("sort");
                boolean sortDescending = sortOrder != null && "desc".equals(sortOrder.toLowerCase());
                int pageSize = Services.parseInt((String)pageSizeParameter, (int)Integer.MAX_VALUE);
                int page = Services.parseInt((String)pageParameter, (int)1);
                PropertyKey sortKey = null;
                if (sortKeyName != null) {
                    Class<? extends GraphObject> type = resource.getEntityClass();
                    sortKey = StructrApp.getConfiguration().getPropertyKeyForDatabaseName(type, sortKeyName, false);
                }
                removeLineBreaks = StringUtils.equals((CharSequence)request.getParameter(REMOVE_LINE_BREAK_PARAM), (CharSequence)"1");
                writeBom = StringUtils.equals((CharSequence)request.getParameter(WRITE_BOM), (CharSequence)"1");
                result = resource.doGet(sortKey, sortDescending, pageSize, page, offsetId);
                result.setIsCollection(resource.isCollectionResource());
                result.setIsPrimitiveArray(resource.isPrimitiveArray());
                PagingHelper.addPagingParameter((Result)result, (int)pageSize, (int)page);
                double queryTimeEnd = System.nanoTime();
                if (result != null) {
                    result.setPropertyView((String)this.propertyView.get(securityContext));
                    resource.postProcessResultSet(result);
                    DecimalFormat decimalFormat = new DecimalFormat("0.000000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
                    result.setQueryTime(decimalFormat.format((queryTimeEnd - queryTimeStart) / 1.0E9));
                    PrintWriter writer = response.getWriter();
                    if (writeBom) {
                        this.writeUtf8Bom(writer);
                    }
                    CsvServlet.writeCsv(result, writer, (String)this.propertyView.get(securityContext));
                    response.setStatus(200);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                } else {
                    logger.log(Level.WARNING, "Result was null!");
                    int code = 204;
                    response.setStatus(code);
                    PrintWriter writer = response.getWriter();
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                }
                tx.success();
            }
            catch (Throwable throwable) {
                var11_22 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var11_22 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var11_22.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (FrameworkException frameworkException) {
            response.setStatus(frameworkException.getStatus());
        }
        catch (JsonSyntaxException jsex) {
            logger.log(Level.WARNING, "JsonSyntaxException in GET", jsex);
            int code = 400;
            response.setStatus(code);
        }
        catch (JsonParseException jpex) {
            logger.log(Level.WARNING, "JsonParseException in GET", jpex);
            int code = 400;
            response.setStatus(code);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Exception in GET", t);
            int code = 500;
            response.setStatus(code);
        }
    }

    private static String escapeForCsv(Object value) {
        String result = StringUtils.replace((String)value.toString(), (String)"\"", (String)"\\\"");
        if (!removeLineBreaks) {
            return StringUtils.replace((String)StringUtils.replace((String)result, (String)"\r\n", (String)"\n"), (String)"\r", (String)"\n");
        }
        return StringUtils.replace((String)StringUtils.replace((String)result, (String)"\r\n", (String)""), (String)"\r", (String)"");
    }

    private void writeUtf8Bom(Writer out) {
        try {
            out.write("\ufeff");
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Unable to write UTF-8 BOM", ex);
        }
    }

    public static void writeCsv(Result result, Writer out, String propertyView) throws IOException {
        List list = result.getResults();
        boolean headerWritten = false;
        for (GraphObject obj : list) {
            StringBuilder row;
            if (!headerWritten) {
                row = new StringBuilder();
                for (PropertyKey key : obj.getPropertyKeys(propertyView)) {
                    row.append("\"").append(key.dbName()).append("\"").append(DELIMITER);
                }
                int pos = row.lastIndexOf(DELIMITER);
                if (pos >= 0) {
                    row.deleteCharAt(pos);
                }
                out.append(row).append("\r\n");
                out.flush();
                headerWritten = true;
            }
            row = new StringBuilder();
            for (PropertyKey key : obj.getPropertyKeys(propertyView)) {
                Object value = obj.getProperty(key);
                row.append("\"").append(value != null ? CsvServlet.escapeForCsv(value) : "").append("\"").append(DELIMITER);
            }
            row.deleteCharAt(row.lastIndexOf(DELIMITER));
            out.append(row).append("\r\n");
            out.flush();
        }
    }

    private class ThreadLocalPropertyView
    extends ThreadLocal<String>
    implements Value<String> {
        private ThreadLocalPropertyView() {
        }

        @Override
        protected String initialValue() {
            return CsvServlet.this.defaultPropertyView;
        }

        public String get(SecurityContext securityContext) {
            return (String)this.get();
        }

        public void set(SecurityContext securityContext, String value) {
            this.set(value);
        }
    }
}

