/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.service;

import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.structr.core.Services;
import org.structr.core.auth.Authenticator;
import org.structr.rest.ResourceProvider;
import org.structr.schema.compiler.NodeExtender;

public class StructrHttpServiceConfig {
    private static final Logger logger = Logger.getLogger(StructrHttpServiceConfig.class.getName());
    private String defaultPropertyView = "public";
    private ResourceProvider resourceProvider = null;
    private Class authenticatorClass = null;
    private boolean userAutoCreate = false;
    private boolean userAutoLogin = false;
    private int outputNestingDepth = 3;

    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    public void setResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProvider = resourceProvider;
    }

    public String getDefaultPropertyView() {
        return this.defaultPropertyView;
    }

    public int getOutputNestingDepth() {
        return this.outputNestingDepth;
    }

    public void initializeFromProperties(Properties properties, String servletName, Set<ResourceProvider> resourceProviders) throws InstantiationException, IllegalAccessException {
        String resourceProviderKeyName = servletName.concat(".resourceprovider");
        String authenticatorKeyName = servletName.concat(".authenticator");
        String userAutoCreateKeyName = servletName.concat(".user.autocreate");
        String userAutoLoginKeyName = servletName.concat(".user.autologin");
        String defaultPropertyKeyName = servletName.concat(".defaultview");
        String nestingDepthKeyName = servletName.concat(".outputdepth");
        String resourceProviderValue = properties.getProperty(resourceProviderKeyName);
        String authenticatorValue = properties.getProperty(authenticatorKeyName);
        String userAutoCreateValue = properties.getProperty(userAutoCreateKeyName);
        String userAutoLoginValue = properties.getProperty(userAutoLoginKeyName);
        String defaultPropertyKeyValue = properties.getProperty(defaultPropertyKeyName);
        String outputDepthValue = properties.getProperty(nestingDepthKeyName);
        if (StringUtils.isBlank((CharSequence)resourceProviderValue)) {
            logger.log(Level.SEVERE, "Missing resource provider key {0}.resourceprovider in configuration file.", servletName);
            throw new IllegalStateException("No resource provider set for servlet " + servletName);
        }
        Class providerClass = this.loadClass(resourceProviderValue);
        if (providerClass == null) {
            logger.log(Level.SEVERE, "Unable to initialize resource provider for servlet {0}, no resource provider found. Please check structr.conf for a valid resource provider class.", servletName);
            throw new IllegalStateException("No resource provider available for servlet " + servletName);
        }
        this.resourceProvider = (ResourceProvider)providerClass.newInstance();
        resourceProviders.add(this.resourceProvider);
        if (StringUtils.isBlank((CharSequence)authenticatorValue)) {
            logger.log(Level.SEVERE, "Missing authenticator key {0}.authenticator in configuration file.", servletName);
        } else {
            this.authenticatorClass = this.loadClass(authenticatorValue);
            if (this.authenticatorClass == null) {
                logger.log(Level.SEVERE, "Unable\t to instantiate authenticator {0}", authenticatorValue);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)userAutoCreateValue)) {
            this.userAutoCreate = Services.parseBoolean((String)userAutoCreateValue, (boolean)false);
        }
        if (StringUtils.isNotBlank((CharSequence)userAutoLoginValue)) {
            this.userAutoLogin = Services.parseBoolean((String)userAutoLoginValue, (boolean)false);
        }
        if (StringUtils.isNotBlank((CharSequence)defaultPropertyKeyValue)) {
            this.defaultPropertyView = defaultPropertyKeyValue;
        }
        if (StringUtils.isNotBlank((CharSequence)outputDepthValue)) {
            this.outputNestingDepth = Services.parseInt((String)outputDepthValue, (int)3);
        }
    }

    public Authenticator getAuthenticator() {
        Authenticator authenticator = null;
        try {
            authenticator = (Authenticator)this.authenticatorClass.newInstance();
            authenticator.setUserAutoCreate(this.userAutoCreate);
            authenticator.setUserAutoLogin(this.userAutoLogin);
        }
        catch (IllegalAccessException | InstantiationException t) {
            logger.log(Level.SEVERE, "Unable to instantiate authenticator {0}: {1}", new Object[]{this.authenticatorClass, t.getMessage()});
        }
        return authenticator;
    }

    private Class loadClass(String name) {
        ClassLoader loader = NodeExtender.getClassLoader();
        Class<?> loadedClass = null;
        if (loader == null) {
            loader = this.getClass().getClassLoader();
        }
        try {
            loadedClass = Class.forName(name, true, loader);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (loadedClass == null) {
            try {
                loadedClass = Class.forName(name);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return loadedClass;
    }
}

