/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.serialization.html;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.structr.rest.serialization.html.Attr;
import org.structr.rest.serialization.html.Block;
import org.structr.rest.serialization.html.Empty;
import org.structr.rest.serialization.html.Inline;
import org.structr.rest.serialization.html.attr.Context;
import org.structr.rest.serialization.html.attr.Css;
import org.structr.rest.serialization.html.attr.Id;

public abstract class Tag {
    private final List<Attr> attrs = new LinkedList<Attr>();
    private final List<Tag> children = new LinkedList<Tag>();
    private boolean empty = false;
    private boolean newline = false;
    private String text = null;
    private String tag = null;
    private String indent = "";
    private Tag parent = null;

    Tag(Tag parent, String tagName) {
        this(parent, tagName, false);
    }

    Tag(Tag parent, String tagName, boolean isEmpty) {
        this(parent, tagName, isEmpty, true);
    }

    Tag(Tag parent, String tagName, boolean isEmpty, boolean newline) {
        this.parent = parent;
        this.tag = tagName;
        this.empty = isEmpty;
        this.newline = StringUtils.isNotEmpty((CharSequence)this.indent) && newline;
    }

    public Tag block(String tagName) {
        Block tag = new Block(this, tagName);
        this.add(tag);
        return tag;
    }

    public Tag inline(String tagName) {
        Inline tag = new Inline(this, tagName);
        this.add(tag);
        return tag;
    }

    public Tag empty(String tagName) {
        Empty tag = new Empty(this, tagName);
        this.add(tag);
        return tag;
    }

    public Tag text(Object ... content) {
        StringBuilder buf = new StringBuilder();
        for (Object p : content) {
            buf.append(p);
        }
        this.text = buf.toString();
        return this;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public List<Tag> getChildren() {
        return this.children;
    }

    public Tag add(Tag tag) {
        this.children.add(tag);
        return this;
    }

    public Tag attr(Attr ... attr) {
        this.attrs.addAll(Arrays.asList(attr));
        return this;
    }

    public Tag id(String id) {
        this.attr(new Id(id));
        return this;
    }

    public Tag css(String css) {
        this.attr(new Css(css));
        return this;
    }

    public Tag parent() {
        return this.parent;
    }

    public void appendComma() {
        if (this.children.size() > 0) {
            ((Tag)((LinkedList)this.getChildren()).getLast()).appendComma();
        } else if (this.text != null) {
            this.text = this.text.concat(",");
        }
    }

    protected void render(PrintWriter writer, int level) throws IOException {
        Tag.beginTag(writer, this.tag, this.empty, this.attrs, level, this.indent);
        if (!this.empty) {
            if (this.text != null) {
                writer.print(this.text);
            }
            if (this.newline) {
                writer.println();
            }
            for (Tag child : this.children) {
                child.render(writer, level + 1);
            }
            Tag.endTag(writer, this.tag, this.newline, level, this.indent);
        }
    }

    protected static void beginTag(PrintWriter writer, String tagName, boolean newline, List<Attr> attributes, int level, String indent) throws IOException {
        Tag.beginTag(writer, tagName, newline, false, attributes, level, indent);
    }

    protected static void beginTag(PrintWriter writer, String tagName, boolean newline, boolean empty, List<Attr> attributes, int level, String indent) throws IOException {
        Context context = new Context(level);
        writer.flush();
        for (int i = 0; i < level; ++i) {
            writer.print(indent);
        }
        writer.print("<" + tagName);
        for (Attr attr : attributes) {
            String output = attr.format(context);
            if (output.length() <= 0) continue;
            writer.print(" " + output);
        }
        if (newline) {
            if (empty) {
                writer.println("/>");
            } else {
                writer.println(">");
            }
        } else if (empty) {
            writer.print("/>");
        } else {
            writer.print(">");
        }
    }

    protected static void endTag(PrintWriter writer, String tagName, boolean hasNewline, int level, String indent) throws IOException {
        writer.flush();
        if (hasNewline) {
            for (int i = 0; i < level; ++i) {
                writer.print(indent);
            }
        }
        writer.println("</" + tagName + ">");
    }
}

