/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.serialization;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.structr.api.Predicate;
import org.structr.common.PermissionResolutionMask;
import org.structr.common.QueryRange;
import org.structr.common.SecurityContext;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.Value;
import org.structr.core.app.StructrApp;
import org.structr.core.converter.PropertyConverter;
import org.structr.core.entity.AbstractNode;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.serialization.RestWriter;

public abstract class StreamingWriter {
    private static final Logger logger = Logger.getLogger(StreamingWriter.class.getName());
    private static final long MAX_SERIALIZATION_TIME = TimeUnit.SECONDS.toMillis(300L);
    private static final Set<PropertyKey> idNameOnly = new LinkedHashSet<PropertyKey>();
    private static final Set<PropertyKey> structrGraph = new LinkedHashSet<PropertyKey>();
    private final Map<String, Serializer> serializerCache = new LinkedHashMap<String, Serializer>();
    private final Map<String, Serializer> serializers = new LinkedHashMap<String, Serializer>();
    private final Serializer<GraphObject> root = new RootSerializer();
    private final Set<String> nonSerializerClasses = new LinkedHashSet<String>();
    private final Set<Integer> visitedObjects = new ConcurrentHashSet();
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000000000", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private String resultKeyName = "result";
    private boolean renderSerializationTime = true;
    private boolean renderResultCount = true;
    private boolean reduceRedundancy = false;
    private int outputNestingDepth = 3;
    private Value<String> propertyView = null;
    protected boolean indent = true;
    protected boolean compactNestedProperties = true;

    public abstract RestWriter getRestWriter(SecurityContext var1, Writer var2);

    public StreamingWriter(Value<String> propertyView, boolean indent, int outputNestingDepth) {
        this.outputNestingDepth = outputNestingDepth;
        this.propertyView = propertyView;
        this.indent = indent;
        this.serializers.put(GraphObject.class.getName(), this.root);
        this.serializers.put(PropertyMap.class.getName(), new PropertyMapSerializer());
        this.serializers.put(Iterable.class.getName(), new IterableSerializer());
        this.serializers.put(Map.class.getName(), new MapSerializer());
        this.nonSerializerClasses.add(Object.class.getName());
        this.nonSerializerClasses.add(String.class.getName());
        this.nonSerializerClasses.add(Integer.class.getName());
        this.nonSerializerClasses.add(Long.class.getName());
        this.nonSerializerClasses.add(Double.class.getName());
        this.nonSerializerClasses.add(Float.class.getName());
        this.nonSerializerClasses.add(Byte.class.getName());
        this.nonSerializerClasses.add(Character.class.getName());
        this.nonSerializerClasses.add(StringBuffer.class.getName());
        this.nonSerializerClasses.add(Boolean.class.getName());
        try {
            this.reduceRedundancy = Boolean.valueOf(Services.getInstance().getConfigurationValue("json.redundancyReduction", "false"));
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Unable to parse value for {0}: {1}", new Object[]{"json.redundancyReduction", t.getMessage()});
        }
    }

    public void streamSingle(SecurityContext securityContext, Writer output, GraphObject obj) throws IOException {
        RestWriter writer = this.getRestWriter(securityContext, output);
        String view = (String)this.propertyView.get(securityContext);
        if (this.indent) {
            writer.setIndent("\t");
        }
        writer.beginDocument(null, view);
        this.root.serialize(writer, obj, view, 0);
        writer.endDocument();
    }

    public void stream(SecurityContext securityContext, Writer output, Result result, String baseUrl) throws IOException {
        long t0 = System.nanoTime();
        RestWriter writer = this.getRestWriter(securityContext, output);
        if (this.indent) {
            writer.setIndent("\t");
        }
        List results = result.getResults();
        Integer page = result.getPage();
        Integer pageCount = result.getPageCount();
        Integer pageSize = result.getPageSize();
        String queryTime = result.getQueryTime();
        Integer resultCount = result.getRawResultCount();
        String searchString = result.getSearchString();
        String sortKey = result.getSortKey();
        String sortOrder = result.getSortOrder();
        GraphObject metaData = result.getMetaData();
        writer.beginDocument(baseUrl, (String)this.propertyView.get(securityContext));
        writer.beginObject();
        if (page != null) {
            writer.name("page").value(page);
        }
        if (pageCount != null) {
            writer.name("page_count").value(pageCount);
        }
        if (pageSize != null) {
            writer.name("page_size").value(pageSize);
        }
        if (queryTime != null) {
            writer.name("query_time").value(queryTime);
        }
        if (resultCount != null && this.renderResultCount) {
            writer.name("result_count").value(resultCount);
        }
        if (results != null) {
            if (results.isEmpty() && result.isPrimitiveArray()) {
                writer.name(this.resultKeyName).nullValue();
            } else if (results.isEmpty() && !result.isPrimitiveArray()) {
                writer.name(this.resultKeyName).beginArray().endArray();
            } else if (result.isPrimitiveArray()) {
                writer.name(this.resultKeyName);
                if (results.size() > 1) {
                    writer.beginArray();
                }
                for (Object object : results) {
                    if (object == null) continue;
                    if (object instanceof GraphObject) {
                        long startTime = System.currentTimeMillis();
                        String localPropertyView = (String)this.propertyView.get(null);
                        GraphObject obj = (GraphObject)object;
                        for (PropertyKey k : obj.getPropertyKeys(localPropertyView)) {
                            Object value = obj.getProperty(k);
                            this.root.serializeProperty(writer, k, value, localPropertyView, 0);
                        }
                        if (System.currentTimeMillis() <= startTime + MAX_SERIALIZATION_TIME) continue;
                        logger.log(Level.SEVERE, "JSON serialization of {0} with {1} results took more than {2} ms, aborted. Please review output view size or adjust timeout.", new Object[]{securityContext.getCompoundRequestURI(), results.size(), MAX_SERIALIZATION_TIME});
                        break;
                    }
                    writer.value(object.toString());
                }
                if (results.size() > 1) {
                    writer.endArray();
                }
            } else {
                if (results.size() > 1 && !result.isCollection()) {
                    throw new IllegalStateException(result.getClass().getSimpleName() + " is not a collection resource, but result set has size " + results.size());
                }
                long startTime = System.currentTimeMillis();
                String localPropertyView = (String)this.propertyView.get(null);
                if (result.isCollection()) {
                    writer.name(this.resultKeyName).beginArray();
                    for (GraphObject graphObject : results) {
                        this.root.serialize(writer, graphObject, localPropertyView, 0);
                        if (System.currentTimeMillis() <= startTime + MAX_SERIALIZATION_TIME) continue;
                        logger.log(Level.SEVERE, "JSON serialization of {0} with {1} results took more than {2} ms, aborted. Please review output view size or adjust timeout.", new Object[]{securityContext.getRequest().getRequestURI().concat(securityContext.getRequest().getQueryString() == null ? "" : "?".concat(securityContext.getRequest().getQueryString())), results.size(), MAX_SERIALIZATION_TIME});
                        break;
                    }
                    writer.endArray();
                } else {
                    writer.name(this.resultKeyName);
                    this.root.serialize(writer, (GraphObject)results.get(0), localPropertyView, 0);
                }
            }
        }
        if (searchString != null) {
            writer.name("search_string").value(searchString);
        }
        if (sortKey != null) {
            writer.name("sort_key").value(sortKey);
        }
        if (sortOrder != null) {
            writer.name("sort_order").value(sortOrder);
        }
        if (metaData != null) {
            String localPropertyView = (String)this.propertyView.get(null);
            writer.name("meta_data");
            this.root.serialize(writer, metaData, localPropertyView, 0);
        }
        if (this.renderSerializationTime) {
            writer.name("serialization_time").value(this.decimalFormat.format((double)(System.nanoTime() - t0) / 1.0E9));
        }
        writer.endObject();
        writer.endDocument();
    }

    public void setResultKeyName(String resultKeyName) {
        this.resultKeyName = resultKeyName;
    }

    public void setRenderSerializationTime(boolean doRender) {
        this.renderSerializationTime = doRender;
    }

    public void setRenderResultCount(boolean doRender) {
        this.renderResultCount = doRender;
    }

    private Serializer getSerializerForType(Class type) {
        Class localType = type;
        Serializer serializer = this.serializerCache.get(type.getName());
        if (serializer == null && !this.nonSerializerClasses.contains(type.getName())) {
            do {
                if ((serializer = this.serializers.get(localType.getName())) == null) {
                    Class interfaceType;
                    LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>();
                    this.collectAllInterfaces(localType, interfaces);
                    Iterator iterator = interfaces.iterator();
                    while (iterator.hasNext() && (serializer = this.serializers.get((interfaceType = (Class)iterator.next()).getName())) == null) {
                    }
                }
                localType = localType.getSuperclass();
            } while (serializer == null && !localType.equals(Object.class));
            if (serializer != null) {
                this.serializerCache.put(type.getName(), serializer);
            }
        }
        return serializer;
    }

    private void collectAllInterfaces(Class type, Set<Class> interfaces) {
        if (interfaces.contains(type)) {
            return;
        }
        for (Class<?> iface : type.getInterfaces()) {
            this.collectAllInterfaces(iface, interfaces);
            interfaces.add(iface);
        }
    }

    private void serializePrimitive(RestWriter writer, Object value) throws IOException {
        if (value != null) {
            if (value instanceof Number) {
                writer.value((Number)value);
            } else if (value instanceof Boolean) {
                writer.value((Boolean)value);
            } else {
                writer.value(value.toString());
            }
        } else {
            writer.nullValue();
        }
    }

    static {
        idNameOnly.add((PropertyKey)GraphObject.id);
        idNameOnly.add((PropertyKey)AbstractNode.name);
        structrGraph.add((PropertyKey)GraphObject.id);
        structrGraph.add((PropertyKey)AbstractNode.type);
        structrGraph.add((PropertyKey)AbstractNode.name);
    }

    public class PropertyMapSerializer
    extends Serializer<PropertyMap> {
        @Override
        public void serialize(RestWriter writer, PropertyMap source, String localPropertyView, int depth) throws IOException {
            writer.beginObject();
            if (depth <= StreamingWriter.this.outputNestingDepth) {
                for (Map.Entry entry : source.entrySet()) {
                    PropertyKey key = (PropertyKey)entry.getKey();
                    Object value = entry.getValue();
                    writer.name(key.jsonName());
                    this.serializeProperty(writer, key, value, localPropertyView, depth + 1);
                }
            }
            writer.endObject();
        }
    }

    public class MapSerializer
    extends Serializer {
        public void serialize(RestWriter writer, Object source, String localPropertyView, int depth) throws IOException {
            writer.beginObject();
            if (depth <= StreamingWriter.this.outputNestingDepth) {
                for (Map.Entry entry : ((Map)source).entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    writer.name(key);
                    this.serializeRoot(writer, value, localPropertyView, depth + 1);
                }
            }
            writer.endObject();
        }
    }

    public class IterableSerializer
    extends Serializer<Iterable> {
        @Override
        public void serialize(RestWriter writer, Iterable value, String localPropertyView, int depth) throws IOException {
            writer.beginArray();
            if (depth <= StreamingWriter.this.outputNestingDepth) {
                for (Object o : value) {
                    this.serializeRoot(writer, o, localPropertyView, depth);
                }
            }
            writer.endArray();
        }
    }

    public class RootSerializer
    extends Serializer<GraphObject> {
        @Override
        public void serialize(RestWriter writer, GraphObject source, String localPropertyView, int depth) throws IOException {
            Iterable keys;
            int hashCode = -1;
            if (source != null) {
                hashCode = source.hashCode();
                StreamingWriter.this.visitedObjects.add(hashCode);
            }
            writer.beginObject(source);
            if (depth <= StreamingWriter.this.outputNestingDepth && (keys = source.getPropertyKeys(localPropertyView)) != null) {
                PermissionResolutionMask permissionResolutionMask = source.getPermissionResolutionMask();
                if (StreamingWriter.this.compactNestedProperties && depth > 0 && "ui".equals(localPropertyView)) {
                    keys = idNameOnly;
                }
                for (PropertyKey key : keys) {
                    Object value;
                    if (permissionResolutionMask != null && !permissionResolutionMask.allowsProperty(key)) continue;
                    QueryRange range = writer.getSecurityContext().getRange(key.jsonName());
                    if (range != null) {
                        range.resetCount();
                    }
                    PropertyKey localKey = key;
                    if ("_graph".equals(localPropertyView) && AbstractNode.name.equals((Object)localKey)) {
                        localKey = StructrApp.getConfiguration().getPropertyKeyForJSONName(source.getClass(), AbstractNode.name.jsonName(), false);
                    }
                    if ((value = source.getProperty(localKey, (Predicate)range)) != null) {
                        if (StreamingWriter.this.reduceRedundancy && StreamingWriter.this.visitedObjects.contains(value.hashCode())) continue;
                        writer.name(key.jsonName());
                        this.serializeProperty(writer, localKey, value, localPropertyView, depth + 1);
                        continue;
                    }
                    writer.name(localKey.jsonName()).nullValue();
                }
            }
            writer.endObject(source);
            StreamingWriter.this.visitedObjects.remove(hashCode);
        }
    }

    public abstract class Serializer<T> {
        public abstract void serialize(RestWriter var1, T var2, String var3, int var4) throws IOException;

        public void serializeRoot(RestWriter writer, Object value, String localPropertyView, int depth) throws IOException {
            Serializer serializer;
            if (value != null && (serializer = StreamingWriter.this.getSerializerForType(value.getClass())) != null) {
                serializer.serialize(writer, value, localPropertyView, depth);
                return;
            }
            StreamingWriter.this.serializePrimitive(writer, value);
        }

        public void serializeProperty(RestWriter writer, PropertyKey key, Object value, String localPropertyView, int depth) {
            block5: {
                try {
                    PropertyConverter converter = key.inputConverter(writer.getSecurityContext());
                    if (converter != null) {
                        Object convertedValue = null;
                        try {
                            convertedValue = converter.revert(value);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.serializeRoot(writer, convertedValue, localPropertyView, depth);
                        break block5;
                    }
                    this.serializeRoot(writer, value, localPropertyView, depth);
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "Exception while serializing property {0} ({1}) of entity {2} (value {3}) : {4}", new Object[]{key.jsonName(), key.getClass(), key.getClass().getDeclaringClass(), value.getClass().getName(), value, t.getMessage()});
                }
            }
        }
    }
}

