/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.PagingHelper;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.ViewTransformation;
import org.structr.core.property.PropertyKey;
import org.structr.rest.resource.WrappingResource;

public class TransformationResource
extends WrappingResource {
    private static final Logger logger = Logger.getLogger(TransformationResource.class.getName());
    private ViewTransformation transformation = null;

    public TransformationResource(SecurityContext securityContext, ViewTransformation transformation) {
        this.securityContext = securityContext;
        this.transformation = transformation;
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        return false;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        if (this.wrappedResource != null && this.transformation != null) {
            if (this.transformation.evaluateWrappedResource()) {
                Result result = this.wrappedResource.doGet(sortKey, sortDescending, Integer.MAX_VALUE, 1, null);
                try {
                    this.transformation.apply(this.securityContext, result.getResults());
                    result.setRawResultCount(Integer.valueOf(result.size()));
                }
                catch (Throwable t) {
                    logger.log(Level.WARNING, "", t);
                }
                return PagingHelper.subResult((Result)result, (int)pageSize, (int)page, (String)offsetId);
            }
            LinkedList listToTransform = new LinkedList();
            this.transformation.apply(this.securityContext, listToTransform);
            Result result = new Result(listToTransform, Integer.valueOf(listToTransform.size()), this.wrappedResource.isCollectionResource(), this.wrappedResource.isPrimitiveArray());
            return PagingHelper.subResult((Result)result, (int)pageSize, (int)page, (String)offsetId);
        }
        List emptyList = Collections.emptyList();
        return new Result(emptyList, null, this.isCollectionResource(), this.isPrimitiveArray());
    }

    @Override
    public String getResourceSignature() {
        if (this.wrappedResource != null) {
            return this.wrappedResource.getResourceSignature();
        }
        return "";
    }
}

