/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.property.BooleanProperty;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.LongProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.SchemaResource;
import org.structr.rest.resource.TypeResource;
import org.structr.rest.resource.ViewFilterResource;
import org.structr.schema.SchemaHelper;

public class SchemaTypeResource
extends Resource {
    protected Class entityClass = null;
    protected String rawType = null;
    protected HttpServletRequest request = null;
    protected TypeResource typeResource = null;
    private String propertyView = null;

    public SchemaTypeResource(SecurityContext securityContext, TypeResource typeResource) {
        this.securityContext = securityContext;
        this.typeResource = typeResource;
        this.rawType = typeResource.getRawType();
    }

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        return true;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        LinkedList<GraphObjectMap> resultList;
        block5: {
            resultList = new LinkedList<GraphObjectMap>();
            Class type = this.typeResource.getEntityClass();
            if (type == null) break block5;
            if (this.propertyView != null) {
                for (Map.Entry<String, Object> entry : this.getPropertiesForView(type, this.propertyView).entrySet()) {
                    GraphObjectMap property = new GraphObjectMap();
                    for (Map.Entry prop : ((Map)entry.getValue()).entrySet()) {
                        property.setProperty((PropertyKey)new GenericProperty((String)prop.getKey()), prop.getValue());
                    }
                    resultList.add(property);
                }
            } else {
                GraphObjectMap schema = new GraphObjectMap();
                resultList.add(schema);
                String url = "/".concat(this.rawType);
                schema.setProperty((PropertyKey)new StringProperty("url"), (Object)url);
                schema.setProperty((PropertyKey)new StringProperty("type"), (Object)type.getSimpleName());
                schema.setProperty((PropertyKey)new StringProperty("className"), (Object)type.getName());
                schema.setProperty((PropertyKey)new BooleanProperty("isRel"), (Object)AbstractRelationship.class.isAssignableFrom(type));
                schema.setProperty((PropertyKey)new LongProperty("flags"), (Object)SecurityContext.getResourceFlags((String)this.rawType));
                LinkedHashSet propertyViews = new LinkedHashSet(StructrApp.getConfiguration().getPropertyViews());
                TreeMap<String, Map<String, Object>> views = new TreeMap<String, Map<String, Object>>();
                schema.setProperty((PropertyKey)new GenericProperty("views"), views);
                for (String view : propertyViews) {
                    if ("_graph".equals(view)) continue;
                    views.put(view, this.getPropertiesForView(type, view));
                }
            }
        }
        return new Result(resultList, Integer.valueOf(resultList.size()), false, false);
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("POST not allowed on " + this.getResourceSignature());
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof ViewFilterResource) {
            this.propertyView = ((ViewFilterResource)next).getPropertyView();
        }
        return this;
    }

    @Override
    public String getUriPart() {
        return this.rawType;
    }

    public String getRawType() {
        return this.rawType;
    }

    public Class getEntityClass() {
        return this.entityClass;
    }

    @Override
    public String getResourceSignature() {
        return SchemaResource.UriPart._schema.name().concat("/").concat(SchemaHelper.normalizeEntityName((String)this.getUriPart()));
    }

    @Override
    public boolean isCollectionResource() {
        return true;
    }

    private Map<String, Object> getPropertiesForView(Class type, String view) throws FrameworkException {
        LinkedHashSet properties = new LinkedHashSet(StructrApp.getConfiguration().getPropertySet(type, view));
        LinkedHashMap<String, Object> propertyConverterMap = new LinkedHashMap<String, Object>();
        for (PropertyKey property : properties) {
            propertyConverterMap.put(property.jsonName(), SchemaHelper.getPropertyInfo((SecurityContext)this.securityContext, (PropertyKey)property));
        }
        return propertyConverterMap;
    }
}

