/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.structr.common.CaseHelper;
import org.structr.common.GraphObjectComparator;
import org.structr.common.Permission;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.Services;
import org.structr.core.Value;
import org.structr.core.app.App;
import org.structr.core.app.Query;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.NodeInterface;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.PropertyMap;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NoResultsException;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.resource.TypeResource;
import org.structr.rest.resource.TypedIdResource;
import org.structr.rest.servlet.JsonRestServlet;
import org.structr.schema.ConfigurationProvider;

public abstract class Resource {
    private static final Logger logger = Logger.getLogger(Resource.class.getName());
    protected SecurityContext securityContext = null;

    public abstract Resource tryCombineWith(Resource var1) throws FrameworkException;

    public abstract boolean checkAndConfigure(String var1, SecurityContext var2, HttpServletRequest var3) throws FrameworkException;

    public abstract String getUriPart();

    public abstract Class<? extends GraphObject> getEntityClass();

    public abstract String getResourceSignature();

    public abstract boolean isCollectionResource() throws FrameworkException;

    public abstract Result doGet(PropertyKey var1, boolean var2, int var3, int var4, String var5) throws FrameworkException;

    public abstract RestMethodResult doPost(Map<String, Object> var1) throws FrameworkException;

    public String toString() {
        return this.getClass().getName() + "(" + this.getResourceSignature() + ")";
    }

    public RestMethodResult doHead() throws FrameworkException {
        Thread.dumpStack();
        throw new IllegalStateException("Resource.doHead() called, this should not happen.");
    }

    public RestMethodResult doOptions() throws FrameworkException {
        return new RestMethodResult(200);
    }

    public RestMethodResult doDelete() throws FrameworkException {
        List results = null;
        try {
            results = this.doGet(null, false, Integer.MAX_VALUE, 1, null).getResults();
        }
        catch (NoResultsException nre) {
            results = null;
        }
        if (results != null) {
            List finalResults = results;
            App app = StructrApp.getInstance((SecurityContext)this.securityContext);
            for (GraphObject obj : finalResults) {
                if (obj instanceof AbstractRelationship) {
                    app.delete((RelationshipInterface)((AbstractRelationship)obj));
                    continue;
                }
                if (!(obj instanceof AbstractNode)) continue;
                AbstractNode node = (AbstractNode)obj;
                if (!node.isGranted(Permission.delete, this.securityContext)) {
                    logger.log(Level.WARNING, "Could not delete {0} because {1} has no delete permission", new Object[]{obj, this.securityContext.getUser(false)});
                    throw new NotAllowedException("Could not delete " + obj + " because " + this.securityContext.getUser(false) + " has no delete permission");
                }
                app.delete((NodeInterface)node);
            }
        }
        return new RestMethodResult(200);
    }

    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        Result result = this.doGet(null, false, Integer.MAX_VALUE, 1, null);
        List results = result.getResults();
        if (results != null && !results.isEmpty()) {
            Class<?> type = ((GraphObject)results.get(0)).getClass();
            PropertyMap properties = PropertyMap.inputTypeToJavaType((SecurityContext)this.securityContext, type, propertySet);
            for (GraphObject obj : results) {
                if (obj.isNode() && !obj.getSyncNode().isGranted(Permission.write, this.securityContext)) {
                    throw new FrameworkException(403, "Modification not permitted.");
                }
                for (Map.Entry attr : properties.entrySet()) {
                    obj.setProperty((PropertyKey)attr.getKey(), attr.getValue());
                }
            }
            return new RestMethodResult(200);
        }
        throw new IllegalPathException(this.getResourceSignature() + " can only be applied to a non-empty resource");
    }

    public void configurePropertyView(Value<String> propertyView) {
    }

    public void postProcessResultSet(Result result) {
    }

    public boolean isPrimitiveArray() {
        return false;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public boolean createPostTransaction() {
        return true;
    }

    protected PropertyKey findPropertyKey(TypedIdResource typedIdResource, TypeResource typeResource) {
        Class sourceNodeType = typedIdResource.getTypeResource().getEntityClass();
        String rawName = typeResource.getRawType();
        PropertyKey key = StructrApp.getConfiguration().getPropertyKeyForJSONName(sourceNodeType, rawName, false);
        if (key == null) {
            key = StructrApp.getConfiguration().getPropertyKeyForJSONName(sourceNodeType, CaseHelper.toLowerCamelCase((String)rawName), false);
        }
        return key;
    }

    protected String buildLocationHeader(GraphObject newObject) {
        StringBuilder uriBuilder = this.securityContext.getBaseURI();
        uriBuilder.append(this.getUriPart());
        uriBuilder.append("/");
        if (newObject != null) {
            uriBuilder.append(newObject.getUuid());
        }
        return uriBuilder.toString();
    }

    protected void applyDefaultSorting(List<? extends GraphObject> list, PropertyKey sortKey, boolean sortDescending) {
        if (!list.isEmpty()) {
            GraphObject obj;
            PropertyKey defaultSort;
            String finalSortOrder;
            String string = finalSortOrder = sortDescending ? "desc" : "asc";
            if (sortKey == null && (defaultSort = (obj = list.get(0)).getDefaultSortKey()) != null) {
                sortKey = defaultSort;
                finalSortOrder = obj.getDefaultSortOrder();
            }
            if (sortKey != null) {
                Collections.sort(list, new GraphObjectComparator(sortKey, finalSortOrder));
            }
        }
    }

    protected void extractDistanceSearch(HttpServletRequest request, Query query) {
        if (request != null) {
            String distance = request.getParameter("distance");
            if (!request.getParameterMap().isEmpty() && StringUtils.isNotBlank((CharSequence)distance)) {
                Double dist = Double.parseDouble(distance);
                String location = request.getParameter("location");
                String street = request.getParameter("street");
                String house = request.getParameter("house");
                String postalCode = request.getParameter("postalCode");
                String city = request.getParameter("city");
                String state = request.getParameter("state");
                String country = request.getParameter("country");
                if (location != null) {
                    String[] parts = location.split("[,]+");
                    switch (parts.length) {
                        case 3: {
                            country = parts[2];
                        }
                        case 2: {
                            city = parts[1];
                        }
                        case 1: {
                            street = parts[0];
                            break;
                        }
                    }
                }
                query.location(street, house, postalCode, city, state, country, dist.doubleValue());
            }
        }
    }

    protected void extractSearchableAttributes(SecurityContext securityContext, Class type, HttpServletRequest request, Query query) throws FrameworkException {
        if (type != null && request != null && !request.getParameterMap().isEmpty()) {
            ConfigurationProvider conf = Services.getInstance().getConfigurationProvider();
            LinkedList<PropertyKey> searchKeys = new LinkedList<PropertyKey>();
            for (String name : request.getParameterMap().keySet()) {
                PropertyKey key = conf.getPropertyKeyForJSONName(type, this.getFirstPartOfString(name), false);
                if (key != null) {
                    if (key.isSearchable()) {
                        searchKeys.add(key);
                        continue;
                    }
                    if (JsonRestServlet.commonRequestParameters.contains(name)) continue;
                    throw new FrameworkException(400, "Search key " + name + " is not indexed.");
                }
                if (JsonRestServlet.commonRequestParameters.contains(name)) continue;
                throw new FrameworkException(400, "Invalid search key " + name);
            }
            Collections.sort(searchKeys, new PropertyKeyProcessingOrderComparator());
            for (PropertyKey key : searchKeys) {
                key.extractSearchableAttribute(securityContext, request, query);
            }
        }
    }

    protected static int parseInteger(Object source) {
        try {
            return Integer.parseInt(source.toString());
        }
        catch (Throwable throwable) {
            return -1;
        }
    }

    private String getFirstPartOfString(String source) {
        int pos = source.indexOf(".");
        if (pos > -1) {
            return source.substring(0, pos);
        }
        return source;
    }

    private static class PropertyKeyProcessingOrderComparator
    implements Comparator<PropertyKey> {
        private PropertyKeyProcessingOrderComparator() {
        }

        @Override
        public int compare(PropertyKey key1, PropertyKey key2) {
            return Integer.valueOf(key1.getProcessingOrderPosition()).compareTo(key2.getProcessingOrderPosition());
        }
    }
}

