/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.structr.api.graph.Direction;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObject;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.entity.AbstractNode;
import org.structr.core.entity.AbstractRelationship;
import org.structr.core.graph.RelationshipInterface;
import org.structr.core.property.PropertyKey;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;
import org.structr.rest.resource.UuidResource;
import org.structr.rest.resource.WrappingResource;

public class RelationshipResource
extends WrappingResource {
    public static final String REQUEST_PARAMETER_FILTER_INTERNAL_RELATIONSHIP_TYPES = "domainOnly";
    private static final Logger logger = Logger.getLogger(RelationshipResource.class.getName());
    private Direction direction = null;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        if ("in".equals(part.toLowerCase())) {
            this.direction = Direction.INCOMING;
            return true;
        }
        if ("out".equals(part.toLowerCase())) {
            this.direction = Direction.OUTGOING;
            return true;
        }
        return false;
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        App app = StructrApp.getInstance();
        List results = this.wrappedResource.doGet(sortKey, sortDescending, pageSize, page, offsetId).getResults();
        if (results != null && !results.isEmpty()) {
            try {
                LinkedList<RelationshipInterface> resultList = new LinkedList<RelationshipInterface>();
                for (GraphObject obj : results) {
                    String filterInternal;
                    if (!(obj instanceof AbstractNode)) continue;
                    List relationships = Direction.INCOMING.equals((Object)this.direction) ? (sortDescending ? app.relationshipQuery().and((PropertyKey)AbstractRelationship.targetId, (Object)obj.getUuid()).sortDescending(sortKey).pageSize(pageSize).page(page).offsetId(offsetId).getAsList() : app.relationshipQuery().and((PropertyKey)AbstractRelationship.targetId, (Object)obj.getUuid()).sortAscending(sortKey).pageSize(pageSize).page(page).offsetId(offsetId).getAsList()) : (sortDescending ? app.relationshipQuery().and((PropertyKey)AbstractRelationship.sourceId, (Object)obj.getUuid()).sortDescending(sortKey).pageSize(pageSize).page(page).offsetId(offsetId).getAsList() : app.relationshipQuery().and((PropertyKey)AbstractRelationship.sourceId, (Object)obj.getUuid()).sortAscending(sortKey).pageSize(pageSize).page(page).offsetId(offsetId).getAsList());
                    if (relationships == null) continue;
                    boolean filterInternalRelationshipTypes = false;
                    if (this.securityContext != null && this.securityContext.getRequest() != null && (filterInternal = this.securityContext.getRequest().getParameter(REQUEST_PARAMETER_FILTER_INTERNAL_RELATIONSHIP_TYPES)) != null) {
                        filterInternalRelationshipTypes = "true".equals(filterInternal);
                    }
                    if (filterInternalRelationshipTypes) {
                        for (RelationshipInterface rel : relationships) {
                            if (rel.isInternal()) continue;
                            resultList.add(rel);
                        }
                        continue;
                    }
                    resultList.addAll(relationships);
                }
                return new Result(resultList, null, this.isCollectionResource(), this.isPrimitiveArray());
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, "Exception while fetching relationships", t);
            }
        } else {
            logger.log(Level.INFO, "No results from parent..");
        }
        throw new IllegalPathException(this.getResourceSignature() + " can only be applied to a non-empty resource");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof UuidResource) {
            return next;
        }
        return super.tryCombineWith(next);
    }

    @Override
    public boolean isCollectionResource() {
        return true;
    }

    @Override
    public String getResourceSignature() {
        return this.wrappedResource.getResourceSignature();
    }
}

