/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.structr.agent.Task;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.Result;
import org.structr.core.app.App;
import org.structr.core.app.StructrApp;
import org.structr.core.graph.MaintenanceCommand;
import org.structr.core.graph.Tx;
import org.structr.core.property.PropertyKey;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.exception.NotAllowedException;
import org.structr.rest.exception.NotFoundException;
import org.structr.rest.exception.SystemException;
import org.structr.rest.resource.MaintenanceParameterResource;
import org.structr.rest.resource.Resource;

public class MaintenanceResource
extends Resource {
    private static final Logger logger = Logger.getLogger(MaintenanceResource.class.getName());
    private String taskOrCommandName = null;
    private Class taskOrCommand = null;

    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) {
        this.securityContext = securityContext;
        return "maintenance".equals(part);
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        throw new NotAllowedException("GET not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doPut(Map<String, Object> propertySet) throws FrameworkException {
        throw new NotAllowedException("PUT not allowed on " + this.getResourceSignature());
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        if (this.securityContext != null && this.isSuperUser()) {
            if (this.taskOrCommand != null) {
                try {
                    App app = StructrApp.getInstance((SecurityContext)this.securityContext);
                    if (Task.class.isAssignableFrom(this.taskOrCommand)) {
                        Task task = (Task)this.taskOrCommand.newInstance();
                        app.processTasks(new Task[]{task});
                    } else if (MaintenanceCommand.class.isAssignableFrom(this.taskOrCommand)) {
                        MaintenanceCommand cmd = (MaintenanceCommand)StructrApp.getInstance((SecurityContext)this.securityContext).command(this.taskOrCommand);
                        if (cmd.requiresEnclosingTransaction()) {
                            try (Tx tx = app.tx();){
                                cmd.execute(propertySet);
                                tx.success();
                            }
                        } else {
                            cmd.execute(propertySet);
                        }
                    } else {
                        return new RestMethodResult(404);
                    }
                    return new RestMethodResult(200);
                }
                catch (InstantiationException iex) {
                    throw new SystemException(iex.getMessage());
                }
                catch (IllegalAccessException iaex) {
                    throw new SystemException(iaex.getMessage());
                }
            }
            if (this.taskOrCommandName != null) {
                throw new NotFoundException("No such task or command: " + this.taskOrCommandName);
            }
            throw new IllegalPathException("Maintenance resource needs parameter");
        }
        throw new NotAllowedException("Use of the maintenance endpoint is restricted to admin users");
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        if (next instanceof MaintenanceParameterResource) {
            MaintenanceParameterResource param = (MaintenanceParameterResource)next;
            this.taskOrCommandName = param.getUriPart();
            this.taskOrCommand = param.getMaintenanceCommand();
            return this;
        }
        return null;
    }

    @Override
    public boolean createPostTransaction() {
        return false;
    }

    public Class getEntityClass() {
        return null;
    }

    @Override
    public String getUriPart() {
        return "maintenance";
    }

    @Override
    public boolean isCollectionResource() {
        return false;
    }

    @Override
    public String getResourceSignature() {
        return this.getUriPart();
    }

    private boolean isSuperUser() throws FrameworkException {
        try (Tx tx = StructrApp.getInstance().tx();){
            boolean bl = this.securityContext.isSuperUser();
            return bl;
        }
    }
}

