/*
 * Decompiled with CFR 0.152.
 */
package org.structr.rest.resource;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.structr.common.SecurityContext;
import org.structr.common.error.FrameworkException;
import org.structr.core.GraphObjectMap;
import org.structr.core.Result;
import org.structr.core.app.StructrApp;
import org.structr.core.property.GenericProperty;
import org.structr.core.property.PropertyKey;
import org.structr.core.property.StringProperty;
import org.structr.rest.RestMethodResult;
import org.structr.rest.exception.IllegalMethodException;
import org.structr.rest.exception.IllegalPathException;
import org.structr.rest.resource.Resource;

public class EnvResource
extends Resource {
    @Override
    public boolean checkAndConfigure(String part, SecurityContext securityContext, HttpServletRequest request) throws FrameworkException {
        this.securityContext = securityContext;
        return UriPart._env.name().equals(part);
    }

    @Override
    public Result doGet(PropertyKey sortKey, boolean sortDescending, int pageSize, int page, String offsetId) throws FrameworkException {
        LinkedList<GraphObjectMap> resultList = new LinkedList<GraphObjectMap>();
        GraphObjectMap info = new GraphObjectMap();
        String classPath = System.getProperty("java.class.path");
        Pattern outerPattern = Pattern.compile("(structr-.+?(?=.jar))");
        Matcher outerMatcher = outerPattern.matcher(classPath);
        HashMap modules = new HashMap();
        while (outerMatcher.find()) {
            String g = outerMatcher.group();
            Pattern innerPattern = Pattern.compile("(structr-core|structr-rest|structr-ui)-([^-]*(?:-SNAPSHOT){0,1})-{0,1}(?:([0-9]{0,12})\\.{0,1}([0-9a-f]{0,5})).*");
            Matcher innerMatcher = innerPattern.matcher(g);
            HashMap<String, String> module = new HashMap<String, String>();
            if (!innerMatcher.matches()) continue;
            module.put("version", innerMatcher.group(2));
            module.put("date", innerMatcher.group(3));
            module.put("build", innerMatcher.group(4));
            modules.put(innerMatcher.group(1), module);
        }
        info.setProperty((PropertyKey)new GenericProperty("modules"), modules);
        info.setProperty((PropertyKey)new StringProperty("classPath"), (Object)classPath);
        info.setProperty((PropertyKey)new StringProperty("instanceName"), (Object)StructrApp.getConfigurationValue((String)"application.instance.name", (String)""));
        info.setProperty((PropertyKey)new StringProperty("instanceStage"), (Object)StructrApp.getConfigurationValue((String)"application.instance.stage", (String)""));
        resultList.add(info);
        return new Result(resultList, Integer.valueOf(resultList.size()), false, false);
    }

    @Override
    public RestMethodResult doPost(Map<String, Object> propertySet) throws FrameworkException {
        throw new IllegalMethodException("POST not allowed on " + this.getResourceSignature());
    }

    @Override
    public Resource tryCombineWith(Resource next) throws FrameworkException {
        throw new IllegalPathException(this.getResourceSignature() + " has no subresources");
    }

    @Override
    public String getUriPart() {
        return this.getResourceSignature();
    }

    public Class getEntityClass() {
        return null;
    }

    @Override
    public String getResourceSignature() {
        return UriPart._env.name();
    }

    @Override
    public boolean isCollectionResource() throws FrameworkException {
        return false;
    }

    public static enum UriPart {
        _env;

    }
}

